/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.hdf5.types;

import hdf.hdf5lib.H5;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import lombok.Generated;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.hdf5.H5Object;
import nz.org.riskscape.hdf5.types.H5ArrayType;
import nz.org.riskscape.hdf5.types.H5CompoundType;
import nz.org.riskscape.hdf5.types.H5EnumType;
import nz.org.riskscape.hdf5.types.H5FloatType;
import nz.org.riskscape.hdf5.types.H5IntegerType;
import nz.org.riskscape.hdf5.types.H5StringType;
import nz.org.riskscape.hdf5.types.H5VlenType;

public abstract class H5Type
extends H5Object {
    private final long dataSize;

    public static H5Type build(long id) {
        int classId = H5.H5Tget_class((long)id);
        String superClassName = H5.H5Tget_class_name((long)classId);
        if (superClassName.equals("H5T_COMPOUND")) {
            return new H5CompoundType(id);
        }
        if (superClassName.equals("H5T_ARRAY")) {
            return new H5ArrayType(id);
        }
        if (superClassName.equals("H5T_INTEGER")) {
            return new H5IntegerType(id);
        }
        if (superClassName.equals("H5T_FLOAT")) {
            return new H5FloatType(id);
        }
        if (superClassName.equals("H5T_ENUM")) {
            return new H5EnumType(id);
        }
        if (superClassName.equals("H5T_STRING")) {
            return new H5StringType(id);
        }
        if (superClassName.equals("H5T_VLEN")) {
            return new H5VlenType(id);
        }
        throw new RuntimeException("unknown type " + superClassName);
    }

    protected H5Type(long ptr) {
        super(ptr);
        this.dataSize = H5.H5Tget_size((long)ptr);
    }

    public abstract Type toType();

    public abstract Object read(ByteBuffer var1, int var2);

    public String getClassName() {
        return H5.H5Tget_class_name((long)H5.H5Tget_class((long)this.ptr));
    }

    public abstract String toString();

    public abstract boolean isVariableLength();

    public Object[] readVlen(byte[] rawBytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(rawBytes);
        byteBuffer.order(ByteOrder.nativeOrder());
        int memberSize = (int)this.getDataSize();
        int numVLenElements = rawBytes.length / memberSize;
        Object[] elements = new Object[numVLenElements];
        int i = 0;
        int offset = 0;
        while (i < numVLenElements) {
            elements[i] = this.read(byteBuffer, offset);
            ++i;
            offset += memberSize;
        }
        return elements;
    }

    @Override
    public void close() {
        H5.H5Tclose((long)this.ptr);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof H5Type)) {
            return false;
        }
        H5Type other = (H5Type)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getDataSize() == other.getDataSize();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof H5Type;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $dataSize = this.getDataSize();
        result = result * 59 + (int)($dataSize >>> 32 ^ $dataSize);
        return result;
    }

    @Generated
    public long getDataSize() {
        return this.dataSize;
    }
}

