/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.hdf5.types;

import hdf.hdf5lib.H5;
import hdf.hdf5lib.HDF5Constants;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.hdf5.types.H5Type;

public class H5StringType
extends H5Type {
    private boolean variableLength;
    private final int characterSet;

    protected H5StringType(long ptr) {
        super(ptr);
        this.variableLength = H5.H5Tis_variable_str((long)ptr);
        this.characterSet = H5.H5Tget_cset((long)ptr);
    }

    @Override
    public Type toType() {
        return Types.TEXT;
    }

    @Override
    public Object read(ByteBuffer outBuf, int offset) {
        if (this.characterSet != HDF5Constants.H5T_CSET_ASCII || this.variableLength) {
            throw new RuntimeException("Read not yet supported for this string type");
        }
        return new String(outBuf.array(), offset, (int)this.getDataSize(), StandardCharsets.US_ASCII).trim();
    }

    @Override
    public String toString() {
        return "H5T_String";
    }

    @Override
    @Generated
    public boolean isVariableLength() {
        return this.variableLength;
    }
}

