/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.hdf5.types;

import hdf.hdf5lib.H5;
import hdf.hdf5lib.HDF5Constants;
import hdf.hdf5lib.HDFNativeData;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import lombok.Generated;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.hdf5.types.H5Type;

public class H5IntegerType
extends H5Type {
    private final boolean isUnsigned;
    private boolean opaqueUnsignedLongs;

    protected H5IntegerType(long id, boolean opaqueUnsignedLongs) {
        super(id);
        this.isUnsigned = H5.H5Tget_sign((long)this.ptr) == HDF5Constants.H5T_SGN_NONE;
        this.opaqueUnsignedLongs = opaqueUnsignedLongs;
    }

    protected H5IntegerType(long id) {
        this(id, false);
    }

    public boolean isUnsigned() {
        return this.isUnsigned;
    }

    public byte[] intToBytes(long value) {
        switch ((int)this.getDataSize()) {
            case 8: {
                return HDFNativeData.longToByte((long)value);
            }
            case 4: {
                return HDFNativeData.intToByte((int)((int)value));
            }
            case 2: {
                return HDFNativeData.shortToByte((short)((short)value));
            }
            case 1: {
                return HDFNativeData.byteToByte((byte)((byte)value));
            }
        }
        throw new RuntimeException("unknown size -" + this.getDataSize());
    }

    @Override
    public Object read(ByteBuffer outBuf, int offset) {
        if (this.isUnsigned()) {
            switch ((int)this.getDataSize()) {
                case 8: {
                    if (this.opaqueUnsignedLongs) {
                        outBuf.getLong(offset);
                    } else {
                        return new BigInteger(Long.toUnsignedString(outBuf.getLong(offset)));
                    }
                }
                case 4: {
                    return Integer.toUnsignedLong(outBuf.getInt(offset));
                }
                case 2: {
                    return Short.toUnsignedLong(outBuf.getShort(offset));
                }
                case 1: {
                    return (long)outBuf.get(offset);
                }
            }
            throw new RuntimeException("unknown size -" + this.getDataSize());
        }
        switch ((int)this.getDataSize()) {
            case 8: {
                return outBuf.getLong(offset);
            }
            case 4: {
                return (long)outBuf.getInt(offset);
            }
            case 2: {
                return (long)outBuf.getShort(offset);
            }
            case 1: {
                return (long)outBuf.get(offset);
            }
        }
        throw new RuntimeException("unknown size - " + this.getDataSize());
    }

    @Override
    public String toString() {
        String unsigned = this.isUnsigned() ? " U" : " ";
        return this.getClassName() + unsigned + this.getDataSize();
    }

    @Override
    public Type toType() {
        if (this.isUnsigned() && this.getDataSize() == 8L) {
            return Types.DECIMAL;
        }
        return Types.INTEGER;
    }

    @Override
    public boolean isVariableLength() {
        return false;
    }

    @Generated
    public void setOpaqueUnsignedLongs(boolean opaqueUnsignedLongs) {
        this.opaqueUnsignedLongs = opaqueUnsignedLongs;
    }

    @Generated
    public boolean isOpaqueUnsignedLongs() {
        return this.opaqueUnsignedLongs;
    }
}

