/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.hdf5.types;

import java.nio.ByteBuffer;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.hdf5.types.H5Type;

public class H5FloatType
extends H5Type {
    protected H5FloatType(long id) {
        super(id);
    }

    @Override
    public Object read(ByteBuffer outBuf, int offset) {
        switch ((int)this.getDataSize()) {
            case 8: {
                return outBuf.getDouble(offset);
            }
            case 4: {
                return (double)outBuf.getFloat(offset);
            }
        }
        throw new RuntimeException("unknown size - " + this.getDataSize());
    }

    @Override
    public String toString() {
        return this.getClassName() + " " + this.getDataSize();
    }

    @Override
    public Type toType() {
        return Types.FLOATING;
    }

    @Override
    public boolean isVariableLength() {
        return false;
    }
}

