/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.hdf5.types;

import hdf.hdf5lib.H5;
import java.nio.ByteBuffer;
import java.util.Arrays;
import nz.org.riskscape.engine.types.Enumeration;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.hdf5.types.H5IntegerType;
import nz.org.riskscape.hdf5.types.H5Type;

public class H5EnumType
extends H5Type {
    private static final int ENUM_NAME_LENGTH = 100;
    private H5IntegerType superType;
    String[] members;

    protected H5EnumType(long id) {
        super(id);
        this.superType = (H5IntegerType)H5Type.build(H5.H5Tget_super((long)id));
        int numFields = H5.H5Tget_nmembers((long)id);
        this.members = new String[numFields];
        for (int i = 0; i < this.members.length; ++i) {
            this.members[i] = H5.H5Tenum_nameof((long)id, (byte[])this.superType.intToBytes(i), (long)100L).intern();
        }
    }

    @Override
    public Type toType() {
        return Enumeration.zeroBased((String[])this.members);
    }

    @Override
    public Object read(ByteBuffer outBuf, int offset) {
        Number index = (Number)this.superType.read(outBuf, offset);
        return this.members[index.intValue()];
    }

    @Override
    public String toString() {
        return this.getClassName() + String.valueOf(Arrays.asList(this.members));
    }

    @Override
    public void close() {
        super.close();
        this.superType.close();
    }

    @Override
    public boolean isVariableLength() {
        return false;
    }
}

