/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.hdf5.types;

import hdf.hdf5lib.H5;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.hdf5.H5CompoundMember;
import nz.org.riskscape.hdf5.types.H5Type;

public class H5CompoundType
extends H5Type {
    private final H5CompoundMember[] membersArray;

    protected H5CompoundType(long id) {
        super(id);
        int numFields = H5.H5Tget_nmembers((long)this.ptr);
        this.membersArray = new H5CompoundMember[numFields];
        int byteCount = 0;
        for (int i = 0; i < numFields; ++i) {
            String memberName = H5.H5Tget_member_name((long)this.ptr, (int)i);
            long memberTypeId = H5.H5Tget_member_type((long)this.ptr, (int)i);
            this.membersArray[i] = new H5CompoundMember(i, memberName, H5Type.build(memberTypeId), this, byteCount);
            byteCount = (int)((long)byteCount + this.membersArray[i].type.getDataSize());
        }
    }

    public int findIndex(String string) {
        for (int i = 0; i < this.getMembersArray().length; ++i) {
            if (!this.getMembersArray()[i].name.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public H5CompoundMember findMember(String string) {
        int index = this.findIndex(string);
        if (index < 0) {
            return null;
        }
        return this.getMembersArray()[index];
    }

    public List<H5CompoundMember> getMembers() {
        return Arrays.asList(this.getMembersArray());
    }

    @Override
    public Object read(ByteBuffer outBuf, int offset) {
        Object[] reading = new Object[this.getMembersArray().length];
        for (int i = 0; i < reading.length; ++i) {
            H5CompoundMember member = this.getMembersArray()[i];
            reading[i] = member.type.read(outBuf, offset);
            offset = (int)((long)offset + member.type.getDataSize());
        }
        return reading;
    }

    @Override
    public Type toType() {
        Struct.StructBuilder builder = new Struct.StructBuilder();
        for (H5CompoundMember member : this.getMembersArray()) {
            builder.add(member.name, member.type.toType());
        }
        return builder.build();
    }

    @Override
    public String toString() {
        return this.getClassName() + " " + String.valueOf(this.getMembers());
    }

    @Override
    public void close() {
        for (H5CompoundMember member : this.getMembersArray()) {
            member.type.close();
        }
        super.close();
    }

    @Override
    public boolean isVariableLength() {
        for (H5CompoundMember member : this.getMembersArray()) {
            if (!member.type.isVariableLength()) continue;
            return true;
        }
        return false;
    }

    public int getByteOffsetFor(int memberIndex) {
        int counter = 0;
        for (int i = 0; i < memberIndex; ++i) {
            counter += (int)this.getMembersArray()[i].type.getDataSize();
        }
        return counter;
    }

    @Generated
    public H5CompoundMember[] getMembersArray() {
        return this.membersArray;
    }
}

