/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.hdf5.types;

import com.google.common.primitives.Longs;
import hdf.hdf5lib.H5;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.hdf5.types.H5Type;

public class H5ArrayType
extends H5Type {
    private H5Type superType;
    private final long[] dimensions;
    private final int itemCount;

    protected H5ArrayType(long id) {
        super(id);
        this.superType = H5Type.build(H5.H5Tget_super((long)id));
        int numDims = H5.H5Tget_array_ndims((long)this.ptr);
        this.dimensions = new long[numDims];
        H5.H5Tget_array_dims((long)this.ptr, (long[])this.dimensions);
        this.itemCount = this.getDimensions().stream().reduce((a, b) -> a * b).orElse(0L).intValue();
    }

    public List<Long> getDimensions() {
        return Longs.asList((long[])this.dimensions);
    }

    @Override
    public Object read(ByteBuffer outBuf, int offset) {
        ArrayList<Object> reading = new ArrayList<Object>(this.itemCount);
        for (int i = 0; i < this.itemCount; ++i) {
            reading.add(this.superType.read(outBuf, offset));
            offset = (int)((long)offset + this.superType.getDataSize());
        }
        return reading;
    }

    public float[] readFloats(ByteBuffer outBuf, int offset) {
        float[] reading = new float[this.itemCount];
        for (int i = 0; i < reading.length; ++i) {
            reading[i] = ((Number)this.superType.read(outBuf, offset)).floatValue();
            offset = (int)((long)offset + this.superType.getDataSize());
        }
        return reading;
    }

    @Override
    public Type toType() {
        return RSList.create((Type)this.getSuperType().toType());
    }

    @Override
    public String toString() {
        return this.getClassName() + "<" + this.getSuperType().toString() + ">" + String.valueOf(this.getDimensions());
    }

    @Override
    public void close() {
        super.close();
        this.superType.close();
    }

    @Override
    public boolean isVariableLength() {
        return this.superType.isVariableLength();
    }

    @Generated
    public H5Type getSuperType() {
        return this.superType;
    }
}

