/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.hdf5.relation;

import java.util.Optional;
import java.util.function.Function;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.relation.BaseRelation;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.hdf5.H5DataSpace;
import nz.org.riskscape.hdf5.H5Dataset;
import nz.org.riskscape.hdf5.cursor.H5DatasetCursor;
import nz.org.riskscape.hdf5.cursor.H5FixedSizeCursor;

public class H5Relation
extends BaseRelation {
    private final H5Dataset dataset;
    private final Function<H5DatasetCursor, Tuple> tupleMapper;
    private final int cursorSizeMB;

    public H5Relation(H5Dataset dataset, Struct producedType, Function<H5DatasetCursor, Tuple> tupleMapper, int cursorSizeMB) {
        super(producedType);
        this.dataset = dataset;
        this.tupleMapper = tupleMapper;
        this.cursorSizeMB = cursorSizeMB;
    }

    private H5Relation(H5Dataset dataset, Function<H5DatasetCursor, Tuple> tupleMapper, int cursorSizeMB, BaseRelation.Fields fields) {
        super(fields);
        this.dataset = dataset;
        this.tupleMapper = tupleMapper;
        this.cursorSizeMB = cursorSizeMB;
    }

    protected TupleIterator rawIterator() {
        final H5DataSpace newDataSpace = this.dataset.newDataSpace();
        final H5FixedSizeCursor cursor = new H5FixedSizeCursor(this.dataset, newDataSpace, this.dataset.getDataType(), this.cursorSizeMB * 1024 * 1024);
        return new TupleIterator(){

            public boolean hasNext() {
                return cursor.hasNext();
            }

            public Tuple next() {
                Tuple next = H5Relation.this.tupleMapper.apply(cursor);
                cursor.skip();
                return next;
            }

            public void close() {
                newDataSpace.close();
            }
        };
    }

    protected BaseRelation clone(BaseRelation.Fields fields) {
        return new H5Relation(this.dataset, this.tupleMapper, this.cursorSizeMB, fields);
    }

    public String getSourceInformation() {
        return this.dataset.toString();
    }

    public Optional<Long> size() {
        return Optional.of(this.dataset.numElements());
    }
}

