/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.hdf5.cursor;

import java.nio.ByteBuffer;
import lombok.Generated;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.hdf5.H5CompoundMember;
import nz.org.riskscape.hdf5.H5DataSpace;
import nz.org.riskscape.hdf5.H5Dataset;
import nz.org.riskscape.hdf5.cursor.H5DatasetCursor;
import nz.org.riskscape.hdf5.types.H5Type;
import nz.org.riskscape.problem.Problems;

public class H5FixedSizeCursor
extends H5DatasetCursor {
    private ByteBuffer byteBuffer;
    private long currentIndex = 0L;
    private int elementOffset = 0;
    private final int elementSizeBytes;
    private final int maxElementsPerRead;

    public H5FixedSizeCursor(H5Dataset dataset, H5DataSpace ds, H5Type type, int cursorBufferSize) {
        super(dataset, ds, type);
        this.elementSizeBytes = (int)type.getDataSize();
        if (ds.numDimensions() > 1) {
            long requiredSizeBytes = ds.numElements() * type.getDataSize();
            if (requiredSizeBytes > (long)cursorBufferSize) {
                throw new RiskscapeException((Problems)PROBLEMS.readSizeTooSmallForMultiDimensionedData(requiredSizeBytes, cursorBufferSize));
            }
            this.maxElementsPerRead = ds.numElementsAsInt();
        } else {
            this.maxElementsPerRead = cursorBufferSize / this.elementSizeBytes;
        }
        this.readElements();
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.numElements;
    }

    public void rewind() {
        this.setCurrentIndex(0L);
    }

    private int position() {
        return this.elementOffset * this.elementSizeBytes;
    }

    @Override
    public void setCurrentIndex(long index) {
        int newElementOffset = this.elementOffset + (int)(index - this.currentIndex);
        this.currentIndex = index;
        if (0 > newElementOffset || newElementOffset >= this.maxElementsPerRead) {
            this.readElements();
        } else {
            this.elementOffset = newElementOffset;
        }
    }

    private void incrementPosition() {
        this.setCurrentIndex(this.currentIndex + 1L);
    }

    @Override
    public Object next() {
        Object read = this.peek();
        this.incrementPosition();
        return read;
    }

    @Override
    public Object peek() {
        return this.type.read(this.byteBuffer, this.position());
    }

    @Override
    public Object peek(H5CompoundMember member) {
        return member.read(this.byteBuffer, this.position());
    }

    @Override
    public void skip() {
        this.incrementPosition();
    }

    private void readElements() {
        if (this.dataspace.numDimensions() > 1) {
            long[] dimStart = new long[this.dataspace.numDimensions()];
            long[] dimCount = new long[this.dataspace.numDimensions()];
            for (int i = 0; i < this.dataspace.numDimensions(); ++i) {
                dimStart[i] = 0L;
                dimCount[i] = this.dataspace.getExtent()[i];
            }
            this.byteBuffer = this.dataspace.readElements(dimStart, dimCount);
        } else {
            long elementsToRead = Math.min((long)this.maxElementsPerRead, this.numElements - this.currentIndex);
            if (elementsToRead > 0L) {
                this.byteBuffer = this.dataspace.readElements(this.currentIndex, elementsToRead);
            }
        }
        this.elementOffset = 0;
    }

    @Generated
    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    @Override
    @Generated
    public long getCurrentIndex() {
        return this.currentIndex;
    }
}

