/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.hdf5;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import hdf.hdf5lib.exceptions.HDF5Exception;
import hdf.hdf5lib.exceptions.HDF5SymbolTableException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.data.relation.RelationBookmarkParams;
import nz.org.riskscape.engine.data.relation.RelationBookmarkResolver;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.relation.ZipRelation;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.hdf5.H5CompoundMember;
import nz.org.riskscape.hdf5.H5Dataset;
import nz.org.riskscape.hdf5.H5DatasetPath;
import nz.org.riskscape.hdf5.H5File;
import nz.org.riskscape.hdf5.cursor.H5DatasetCursor;
import nz.org.riskscape.hdf5.relation.H5Relation;
import nz.org.riskscape.hdf5.types.H5CompoundType;
import nz.org.riskscape.hdf5.types.H5Type;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public class Hdf5Resolver
extends RelationBookmarkResolver<Parameters> {
    public static final Range<Integer> ALLOWED_READ_SIZE_MB = Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2048));
    static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);
    private final Map<String, String> extensionsToFormats = ImmutableMap.of((Object)"hdf5", (Object)"hdf5");

    public Hdf5Resolver(Engine engine) {
        super(engine);
    }

    protected ResultOrProblems build(Parameters parameters) {
        switch (parameters.mode) {
            case RELATION: {
                return super.build((RelationBookmarkParams)parameters);
            }
        }
        throw new UnsupportedOperationException(parameters.mode.toString());
    }

    private H5Relation createRelation(Parameters params, String datasetName) throws ProblemException {
        H5Dataset dataset = params.openDataset(datasetName);
        Struct producedType = this.getProducedType(dataset, params);
        Function<H5DatasetCursor, Tuple> bufferToTupleMapper = this.getBufferToTupleMapper(dataset.getDataType(), producedType);
        return new H5Relation(dataset, producedType, bufferToTupleMapper, params.readSizeMb);
    }

    protected ResultOrProblems<Relation> createRawRelationFromBookmark(Parameters params) {
        return ProblemException.catching(() -> {
            if (params.dataset.size() == 1) {
                return this.createRelation(params, params.dataset.get(0));
            }
            ArrayList<H5Relation> relations = new ArrayList<H5Relation>();
            for (String datasetName : params.dataset) {
                relations.add(this.createRelation(params, datasetName));
            }
            try {
                return new ZipRelation(relations);
            }
            catch (RiskscapeException ex) {
                if (ZipRelation.PROBLEMS.mismatchingRows().equals((Object)ex.getProblem())) {
                    throw new ProblemException((Problems)PROBLEMS.differentDatasetSizes());
                }
                throw new ProblemException((Problems)ex.getProblem());
            }
        });
    }

    private Struct getProducedType(H5Dataset dataset, Parameters params) throws ProblemException {
        List<String> includeAttributes = params.getIncludeAttributeList();
        Struct.StructBuilder builder = Struct.builder();
        ArrayList<String> available = new ArrayList<String>();
        H5Type dataType = dataset.getDataType();
        if (dataType instanceof H5CompoundType) {
            H5CompoundType compoundDataType = (H5CompoundType)dataType;
            for (H5CompoundMember member : compoundDataType.getMembers()) {
                available.add(member.name);
                if (!includeAttributes.isEmpty() && !includeAttributes.contains(member.name)) continue;
                builder.add(member.name, member.type.toType());
            }
        } else if (includeAttributes.size() == 1) {
            available.add(includeAttributes.get(0));
            builder.add(includeAttributes.get(0), dataType.toType());
        } else {
            available.add(dataset.getDatasetName());
            builder.add(dataset.getDatasetName(), dataType.toType());
        }
        Struct produced = (Struct)builder.buildOr().getOrThrow();
        for (String attribute : includeAttributes) {
            if (produced.hasMember(attribute)) continue;
            throw new ProblemException((Problems)GeneralProblems.get().notAnOption(attribute, (Object)"include-attributes", available));
        }
        return produced;
    }

    private Function<H5DatasetCursor, Tuple> getBufferToTupleMapper(H5Type dataType, Struct producedType) {
        if (!(dataType instanceof H5CompoundType)) {
            return cursor -> Tuple.ofValues((Struct)producedType, (Object[])new Object[]{cursor.peek()});
        }
        ArrayList<H5CompoundMember> membersToFetch = new ArrayList<H5CompoundMember>();
        H5CompoundType compoundDataType = (H5CompoundType)dataType;
        for (Struct.StructMember member : producedType.getMembers()) {
            membersToFetch.add(compoundDataType.findMember(member.getKey()));
        }
        return cursor -> {
            Object[] values = membersToFetch.stream().map(member -> cursor.peek((H5CompoundMember)member)).toArray();
            return Tuple.ofValues((Struct)producedType, (Object[])values);
        };
    }

    protected void validateParameters(Parameters params, BindingContext context) {
        super.validateParameters((RelationBookmarkParams)params, context);
        if (!ALLOWED_READ_SIZE_MB.contains((Comparable)Integer.valueOf(params.readSizeMb))) {
            params.problems.add(GeneralProblems.get().valueOutOfRange((Object)"read-size-mb", (Comparable)Integer.valueOf(params.readSizeMb), ALLOWED_READ_SIZE_MB));
        }
    }

    @Generated
    public Map<String, String> getExtensionsToFormats() {
        return this.extensionsToFormats;
    }

    public static class Parameters
    extends RelationBookmarkParams {
        @ParameterField
        public DatasetMode mode = DatasetMode.RELATION;
        @ParameterField(minRequired=1)
        public List<String> dataset;
        @ParameterField
        public Optional<String> includeAttributes = Optional.empty();
        @ParameterField
        public int readSizeMb = 64;
        public H5File h5File;

        public Class<?> getDataType() {
            if (this.mode != null) {
                return this.mode.getDataType();
            }
            return null;
        }

        H5File getH5File() throws ProblemException {
            if (this.h5File == null) {
                Path path = this.getBookmarkedPath();
                if (path == null) {
                    throw new ProblemException((Problems)PROBLEMS.hdf5FileLoadError("HDF5 plugin could not load file"));
                }
                this.h5File = new H5File(path);
            }
            return this.h5File;
        }

        H5Dataset openDataset(String name) throws ProblemException {
            try {
                return this.getH5File().openDataset(H5DatasetPath.parse(name));
            }
            catch (HDF5SymbolTableException e) {
                throw new ProblemException((Problems)PROBLEMS.hdf5DatasetDoesNotExist(name));
            }
            catch (HDF5Exception e) {
                throw new ProblemException((Problems)PROBLEMS.hdf5FileLoadError(e.getMessage()));
            }
        }

        List<String> getIncludeAttributeList() {
            return this.includeAttributes.map(attributesString -> Arrays.stream(attributesString.split(",")).map(param -> param.trim()).collect(Collectors.toList())).orElse(Collections.emptyList());
        }
    }

    public static enum DatasetMode {
        RELATION(Relation.class);

        private final Class<?> dataType;

        private DatasetMode(Class<?> dataType) {
            this.dataType = dataType;
        }

        public Class<?> getDataType() {
            return this.dataType;
        }
    }

    static interface LocalProblems
    extends ProblemFactory {
        public Problem hdf5FileLoadError(String var1);

        public Problem hdf5DatasetDoesNotExist(String var1);

        public Problem differentDatasetSizes();
    }
}

