/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.hdf5;

import hdf.hdf5lib.H5;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.Identified;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.plugin.Plugin;
import nz.org.riskscape.engine.plugin.PluginDescriptor;
import nz.org.riskscape.engine.plugin.PluginFeature;
import nz.org.riskscape.engine.plugin.PluginRuntimeException;
import nz.org.riskscape.engine.spi.CliCommand;
import nz.org.riskscape.hdf5.Hdf5Command;
import nz.org.riskscape.hdf5.Hdf5Resolver;
import nz.org.riskscape.problem.Problem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hdf5Plugin
extends Plugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Hdf5Plugin.class);
    public static final Parameter SETTING_LIB_PATH = Parameter.required((String)"hdf5.lib_path", String.class);
    private final List<PluginFeature> features = Arrays.asList(new CliCommand(Hdf5Command.class));

    public Hdf5Plugin(PluginDescriptor pDescriptor) {
        super(pDescriptor);
    }

    public void startUp(Map<String, List<String>> settings) throws PluginRuntimeException {
        this.loadLibrary(settings);
    }

    private void loadLibrary(Map<String, List<String>> settings) {
        List<String> optionalPath = settings.get(SETTING_LIB_PATH.getName());
        if (optionalPath != null && !optionalPath.isEmpty()) {
            String path = Paths.get(optionalPath.get(0), new String[0]).toAbsolutePath().toString();
            System.setProperty("hdf.hdf5lib.H5.hdf5lib", path);
            log.info("{} is set to {}, setting H5 path for H5.loadH5Lib...", (Object)SETTING_LIB_PATH.getName(), (Object)path);
        } else {
            log.info("{} is not set, relying on system load path to find hdf5...", (Object)SETTING_LIB_PATH.getName());
        }
        try {
            H5.loadH5Lib();
            H5.H5open();
        }
        catch (Throwable e) {
            throw new PluginRuntimeException(e, "Failed to load hdf5 library - %s", new Object[]{e.getMessage()});
        }
    }

    public List<Problem> initializeEngine(Engine engine) {
        engine.getBookmarkResolvers().add((Identified)new Hdf5Resolver(engine));
        return Collections.emptyList();
    }

    @Generated
    public List<PluginFeature> getFeatures() {
        return this.features;
    }
}

