/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.hdf5;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.cli.EngineOnlyCommand;
import nz.org.riskscape.engine.cli.StubCommand;
import nz.org.riskscape.engine.cli.Table;
import nz.org.riskscape.engine.i18n.MessageSource;
import nz.org.riskscape.hdf5.H5Dataset;
import nz.org.riskscape.hdf5.H5File;
import nz.org.riskscape.hdf5.H5Group;
import nz.org.riskscape.hdf5.H5Object;
import nz.org.riskscape.picocli.CommandLine;

@CommandLine.Command(name="hdf5", subcommands={LsCommand.class})
public class Hdf5Command
extends StubCommand {

    @CommandLine.Command(name="ls")
    public static class LsCommand
    extends EngineOnlyCommand {
        @CommandLine.Parameters(arity="1", index="0")
        public Path hdf5File;
        @CommandLine.Parameters(arity="0..1", index="1")
        public String location;

        public Object doCommand(Engine useEngine) {
            H5File h5file = new H5File(this.hdf5File);
            try {
                H5Object opened;
                if (this.location == null) {
                    this.location = "/";
                }
                try {
                    opened = h5file.openObject(this.location);
                }
                catch (RuntimeException e) {
                    this.printerr("Failed to open object %s  - %s", new Object[]{this.location, e.toString()});
                    e.printStackTrace(this.stderr());
                    Object var5_8 = null;
                    h5file.close();
                    return var5_8;
                }
                ArrayList<H5Object> children = new ArrayList<H5Object>();
                if (opened instanceof H5Group) {
                    H5Group group = (H5Group)opened;
                    group.visit((parent, childName, supplier) -> {
                        try {
                            children.add((H5Object)supplier.get());
                        }
                        catch (RuntimeException e) {
                            this.printerr("Failed to open object %s/%s  - %s", new Object[]{this.location, childName, e.toString()});
                            e.printStackTrace(this.stderr());
                        }
                    });
                }
                if (opened instanceof H5Dataset) {
                    children.add(opened);
                }
                Table table = Table.fromList(children, H5Object.class, (MessageSource)this.getMessages().getLabels(), Arrays.asList(Table.Property.of((String)"name", obj -> this.getName((H5Object)obj)), Table.Property.of((String)"type", obj -> this.getType((H5Object)obj)), Table.Property.of((String)"size", obj -> this.getSize((H5Object)obj))));
                table.print(this.getTerminal());
                for (H5Object h5Object : children) {
                    h5Object.close();
                }
            }
            finally {
                try {
                    h5file.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
            return null;
        }

        private String getSize(H5Object obj) {
            if (obj instanceof H5Group) {
                H5Group group = (H5Group)obj;
                AtomicLong counter = new AtomicLong(0L);
                group.visit((a, b, c) -> counter.incrementAndGet());
                return counter.toString();
            }
            H5Dataset dataset = (H5Dataset)obj;
            long total = 1L;
            StringBuilder builder = new StringBuilder();
            long[] extent = dataset.getDataSpace().getExtent();
            boolean first = true;
            for (long dimSize : extent) {
                if (!first) {
                    builder.append("x");
                }
                builder.append(dimSize);
                first = false;
                total *= dimSize;
            }
            if (extent.length > 1) {
                builder.append(" (Total size: ").append(total).append(")");
            }
            return builder.toString();
        }

        private String getType(H5Object obj) {
            if (obj instanceof H5Group) {
                return "(Group)";
            }
            H5Dataset dataset = (H5Dataset)obj;
            return dataset.getDataType().toString();
        }

        public String getName(H5Object obj) {
            if (obj instanceof H5Group) {
                return ((H5Group)obj).getGroupName();
            }
            return ((H5Dataset)obj).getDatasetName();
        }
    }
}

