/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.hdf5;

import hdf.hdf5lib.H5;
import hdf.hdf5lib.HDF5Constants;
import hdf.hdf5lib.callbacks.H5L_iterate_opdata_t;
import hdf.hdf5lib.callbacks.H5L_iterate_t;
import hdf.hdf5lib.exceptions.HDF5SymbolTableException;
import hdf.hdf5lib.structs.H5O_info_t;
import java.util.ArrayList;
import lombok.Generated;
import nz.org.riskscape.hdf5.H5Dataset;
import nz.org.riskscape.hdf5.H5GroupVisitor;
import nz.org.riskscape.hdf5.H5Object;

public class H5Group
extends H5Object {
    private final H5Group parent;
    private final String groupName;

    static H5Group getRootGroup(long ptr) {
        return new H5Group(ptr);
    }

    H5Group(H5Group parent, long ptr, String name) {
        super(ptr);
        this.groupName = name;
        this.parent = parent;
    }

    private H5Group(long ptr) {
        super(ptr);
        this.groupName = "/";
        this.parent = this;
    }

    @Override
    public void close() {
        H5.H5Oclose((long)this.ptr);
    }

    public String toString() {
        return "H5Group(" + this.groupName + ")";
    }

    public boolean isRoot() {
        return this.parent == this;
    }

    public void visit(H5GroupVisitor visitor) {
        IterateData opData = new IterateData();
        H5L_iterate_t callback = (parentGroupId, childName, info, itData) -> {
            H5O_info_t objectInfo = H5.H5Oget_info_by_name((long)parentGroupId, (String)childName, (long)HDF5Constants.H5P_DEFAULT);
            if (objectInfo.type == HDF5Constants.H5O_TYPE_DATASET) {
                visitor.visit(this, childName, () -> this.openDataset(childName));
            }
            if (objectInfo.type == HDF5Constants.H5O_TYPE_GROUP) {
                visitor.visit(this, childName, () -> this.openGroup(childName));
            }
            return 0;
        };
        H5.H5Literate((long)this.ptr, (int)HDF5Constants.H5_INDEX_NAME, (int)HDF5Constants.H5_ITER_NATIVE, (long)0L, (H5L_iterate_t)callback, (H5L_iterate_opdata_t)opData);
    }

    public H5Object openChild(String childName) {
        H5O_info_t objectInfo;
        try {
            objectInfo = H5.H5Oget_info_by_name((long)this.ptr, (String)childName, (long)HDF5Constants.H5P_DEFAULT);
        }
        catch (HDF5SymbolTableException e) {
            throw new RuntimeException("Could not find object " + childName + " inside group " + this.groupName, e);
        }
        if (objectInfo.type == HDF5Constants.H5O_TYPE_DATASET) {
            return this.openDataset(childName);
        }
        if (objectInfo.type == HDF5Constants.H5O_TYPE_GROUP) {
            return this.openGroup(childName);
        }
        return null;
    }

    private H5Group openGroup(String childName) {
        return new H5Group(this, H5.H5Gopen((long)this.ptr, (String)childName, (long)HDF5Constants.H5P_DEFAULT), childName);
    }

    private H5Dataset openDataset(String datasetName) {
        return new H5Dataset(H5.H5Dopen((long)this.ptr, (String)datasetName, (long)HDF5Constants.H5P_DEFAULT), datasetName);
    }

    @Generated
    public H5Group getParent() {
        return this.parent;
    }

    @Generated
    public String getGroupName() {
        return this.groupName;
    }

    private static class IterateData
    implements H5L_iterate_opdata_t {
        public ArrayList<?> iterdata = new ArrayList(0);

        private IterateData() {
        }
    }
}

