/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.hdf5;

import hdf.hdf5lib.H5;
import hdf.hdf5lib.HDF5Constants;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.function.Function;
import nz.org.riskscape.hdf5.H5Dataset;
import nz.org.riskscape.hdf5.H5DatasetPath;
import nz.org.riskscape.hdf5.H5Group;
import nz.org.riskscape.hdf5.H5Object;

public class H5File
extends H5Object {
    public H5File(Path path) {
        this(path.toString());
    }

    public H5File(String filename) {
        super(H5.H5Fopen((String)filename, (int)HDF5Constants.H5F_ACC_RDONLY, (long)HDF5Constants.H5P_DEFAULT));
    }

    public H5Group getRootGroup() {
        return H5Group.getRootGroup(H5.H5Gopen((long)this.ptr, (String)"/", (long)HDF5Constants.H5P_DEFAULT));
    }

    public <T> T applyRootGroup(Function<H5Group, T> callback) {
        try (H5Group root = this.getRootGroup();){
            T t = callback.apply(root);
            return t;
        }
    }

    public void acceptRootGroup(Consumer<H5Group> callback) {
        try (H5Group root = this.getRootGroup();){
            callback.accept(root);
        }
    }

    public H5Object openObject(String path) {
        if (path.equals("/")) {
            return this.getRootGroup();
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return this.getRootGroup().openChild(path);
    }

    public H5Dataset openDataset(H5DatasetPath datasetId) {
        return this.openDataset(datasetId.groupName, datasetId.datasetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public H5Dataset openDataset(String groupPath, String datasetName) {
        long groupId = H5.H5Gopen((long)this.ptr, (String)groupPath, (long)HDF5Constants.H5P_DEFAULT);
        try {
            long datasetId = H5.H5Dopen((long)groupId, (String)datasetName, (long)HDF5Constants.H5P_DEFAULT);
            H5Dataset h5Dataset = new H5Dataset(datasetId, datasetName);
            return h5Dataset;
        }
        finally {
            H5.H5Gclose((long)groupId);
        }
    }

    @Override
    public void close() {
        H5.H5Fclose((long)this.ptr);
    }
}

