/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.hdf5;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public class H5DatasetPath {
    private static Joiner joiner = Joiner.on((String)"/");
    public final String groupName;
    public final String datasetName;

    public static H5DatasetPath parse(String path) {
        List<String> split = Arrays.asList(path.split("/"));
        if (split.size() == 1) {
            return new H5DatasetPath("/", split.get(0));
        }
        if (split.get(0).equals("")) {
            split = split.subList(1, split.size());
        }
        List<String> head = split.subList(0, split.size() - 1);
        String tail = split.get(split.size() - 1);
        return new H5DatasetPath("/" + joiner.join(head), tail);
    }

    public String getPath() {
        return String.format("%s/%s", this.groupName, this.datasetName);
    }

    @Generated
    public String getGroupName() {
        return this.groupName;
    }

    @Generated
    public String getDatasetName() {
        return this.datasetName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof H5DatasetPath)) {
            return false;
        }
        H5DatasetPath other = (H5DatasetPath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$groupName = this.getGroupName();
        String other$groupName = other.getGroupName();
        if (this$groupName == null ? other$groupName != null : !this$groupName.equals(other$groupName)) {
            return false;
        }
        String this$datasetName = this.getDatasetName();
        String other$datasetName = other.getDatasetName();
        return !(this$datasetName == null ? other$datasetName != null : !this$datasetName.equals(other$datasetName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof H5DatasetPath;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupName = this.getGroupName();
        result = result * 59 + ($groupName == null ? 43 : $groupName.hashCode());
        String $datasetName = this.getDatasetName();
        result = result * 59 + ($datasetName == null ? 43 : $datasetName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "H5DatasetPath(groupName=" + this.getGroupName() + ", datasetName=" + this.getDatasetName() + ")";
    }

    @Generated
    public H5DatasetPath(String groupName, String datasetName) {
        this.groupName = groupName;
        this.datasetName = datasetName;
    }
}

