/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.hdf5;

import hdf.hdf5lib.H5;
import hdf.hdf5lib.HDF5Constants;
import lombok.Generated;
import nz.org.riskscape.hdf5.H5DataSpace;
import nz.org.riskscape.hdf5.H5Object;
import nz.org.riskscape.hdf5.cursor.H5DatasetCursor;
import nz.org.riskscape.hdf5.cursor.H5FixedSizeCursor;
import nz.org.riskscape.hdf5.types.H5Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H5Dataset
extends H5Object {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(H5Dataset.class);
    private final H5Type dataType;
    private final H5DataSpace dataSpace;
    private final String datasetName;
    private static final int DEFAULT_CURSOR_SIZE = 0x4000000;

    H5Dataset(long objectId, String datasetName) {
        super(objectId);
        this.datasetName = datasetName;
        this.dataType = H5Type.build(H5.H5Dget_type((long)this.ptr));
        this.dataSpace = new H5DataSpace(H5.H5Dget_space((long)this.ptr), this);
        log.debug("Opened new H5Dataset {}", (Object)datasetName);
    }

    public H5DatasetCursor openCursor(int bufferSize) {
        if (this.dataType.isVariableLength()) {
            throw new RuntimeException("Variable length data types not supported");
        }
        return new H5FixedSizeCursor(this, this.dataSpace, this.dataType, bufferSize);
    }

    public H5DatasetCursor openCursor() {
        return this.openCursor(0x4000000);
    }

    public H5DataSpace newDataSpace() {
        return new H5DataSpace(H5.H5Dget_space((long)this.ptr), this, (long[])this.dataSpace.getExtent().clone());
    }

    @Override
    public void close() {
        H5.H5Dclose((long)this.ptr);
        this.dataSpace.close();
        this.dataType.close();
        log.debug("Closed H5Dataset {}", (Object)this.datasetName);
    }

    public double[] getElementsAsDouble() {
        H5DatasetCursor cursor = this.openCursor();
        int i = 0;
        double[] values = new double[this.getDataSpace().numElementsAsInt()];
        while (cursor.hasNext()) {
            values[i++] = (Double)cursor.next();
        }
        return values;
    }

    public long numElements() {
        return this.dataSpace.numElements();
    }

    public String toString() {
        return String.format("H5Dataset(name=%s type=%s size=%d)", this.datasetName, this.dataType, this.numElements());
    }

    public byte[][] readVlenElements(H5DataSpace memspace, H5DataSpace filespace, int numElements) {
        byte[][] buffer = new byte[numElements][0];
        H5.H5DreadVL((long)this.ptr, (long)this.dataType.ptr, (long)memspace.ptr, (long)filespace.ptr, (long)HDF5Constants.H5P_DEFAULT, (Object[])buffer);
        return buffer;
    }

    @Generated
    public H5Type getDataType() {
        return this.dataType;
    }

    @Generated
    public H5DataSpace getDataSpace() {
        return this.dataSpace;
    }

    @Generated
    public String getDatasetName() {
        return this.datasetName;
    }
}

