/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.hdf5;

import hdf.hdf5lib.H5;
import hdf.hdf5lib.HDF5Constants;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import lombok.Generated;
import nz.org.riskscape.hdf5.H5Dataset;
import nz.org.riskscape.hdf5.H5Object;

public class H5DataSpace
extends H5Object {
    private final H5Dataset dataset;
    private final long[] extent;

    public static H5DataSpace createMemSpace(long[] dims) {
        return new H5DataSpace(H5.H5Screate_simple((int)dims.length, (long[])dims, null), null, dims);
    }

    public static H5DataSpace createMemSpace(long numElements) {
        return H5DataSpace.createMemSpace(new long[]{numElements});
    }

    private static long[] readH5Dimensions(long ptr) {
        long[] dims = new long[H5.H5Sget_simple_extent_ndims((long)ptr)];
        H5.H5Sget_simple_extent_dims((long)ptr, (long[])dims, null);
        return dims;
    }

    public H5DataSpace(long id, H5Dataset dataset) {
        this(id, dataset, H5DataSpace.readH5Dimensions(id));
    }

    public H5DataSpace(long id, H5Dataset parentDataset, long[] dims) {
        super(id);
        this.dataset = parentDataset;
        this.extent = dims;
    }

    public long numElements() {
        long counter = 0L;
        for (int i = 0; i < this.extent.length; ++i) {
            if (counter == 0L) {
                counter = this.extent[i];
                continue;
            }
            if (this.extent[i] == 0L) continue;
            counter *= this.extent[i];
        }
        return counter;
    }

    public int numElementsAsInt() {
        long numElements = this.numElements();
        if (numElements > Integer.MAX_VALUE) {
            throw new IllegalStateException("Dataset too big to store as integer");
        }
        return (int)numElements;
    }

    public void selectElements(long[] start, long[] count) {
        long[] stride = new long[this.numDimensions()];
        Arrays.fill(stride, 1L);
        H5.H5Sselect_hyperslab((long)this.ptr, (int)HDF5Constants.H5S_SELECT_SET, (long[])start, (long[])stride, (long[])count, null);
    }

    public void selectElementsAt(long[][] locations) {
        H5.H5Sselect_elements((long)this.ptr, (int)HDF5Constants.H5S_SELECT_SET, (int)locations.length, (long[][])locations);
    }

    public ByteBuffer readElements(long start, long count) {
        return this.readElements(new long[]{start}, new long[]{count});
    }

    public ByteBuffer readElements(long[] start, long[] count) {
        try (H5DataSpace memspace = H5DataSpace.createMemSpace(count);){
            long totalCount = Arrays.stream(count).reduce(1L, (l, r) -> l * r);
            long bytesNeeded = totalCount * this.dataset.getDataType().getDataSize();
            byte[] byteArray = new byte[(int)bytesNeeded];
            this.selectElements(start, count);
            H5.H5Dread((long)this.dataset.getPointer(), (long)this.dataset.getDataType().getPointer(), (long)memspace.getPointer(), (long)this.getPointer(), (long)HDF5Constants.H5P_DEFAULT, (byte[])byteArray);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byteArray);
            byteBuffer.order(ByteOrder.nativeOrder());
            ByteBuffer byteBuffer2 = byteBuffer;
            return byteBuffer2;
        }
    }

    public int numDimensions() {
        return this.getExtent().length;
    }

    @Override
    public void close() {
        H5.H5Sclose((long)this.ptr);
    }

    @Generated
    public long[] getExtent() {
        return this.extent;
    }
}

