/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.hdf5;

import hdf.hdf5lib.H5;
import hdf.hdf5lib.HDF5Constants;
import hdf.hdf5lib.exceptions.HDF5Exception;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import lombok.Generated;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.hdf5.H5Object;
import nz.org.riskscape.hdf5.types.H5Type;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;

public class H5Attribute
extends H5Object {
    private final String name;
    private final H5Type dataType;
    private final H5Object parent;

    public H5Attribute(H5Object object, String name) {
        super(H5.H5Aopen((long)object.ptr, (String)name, (long)HDF5Constants.H5P_DEFAULT));
        this.name = name;
        this.dataType = H5Type.build(H5.H5Aget_type((long)this.ptr));
        this.parent = object;
    }

    public Object read() {
        byte[] dataBytes = new byte[(int)this.dataType.getDataSize()];
        H5.H5Aread((long)this.ptr, (long)this.dataType.ptr, (byte[])dataBytes);
        ByteBuffer byteBuffer = ByteBuffer.wrap(dataBytes);
        byteBuffer.order(ByteOrder.nativeOrder());
        return this.dataType.read(byteBuffer, 0);
    }

    @Override
    public void close() {
        H5.H5Aclose((long)this.ptr);
    }

    public String toString() {
        return "HDF5 Attribute '" + this.name + "'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> ResultOrProblems<T> readValue(H5Object object, String attributeName, Class<T> expectedType) {
        Object value;
        H5Attribute attribute;
        Problem missingAttribute = GeneralProblems.get().noSuchObjectExists(attributeName, H5Attribute.class);
        try {
            attribute = new H5Attribute(object, attributeName);
        }
        catch (HDF5Exception e) {
            return ResultOrProblems.failed((Problem[])new Problem[]{missingAttribute});
        }
        try {
            value = attribute.read();
        }
        finally {
            attribute.close();
        }
        if (value == null) {
            return ResultOrProblems.failed((Problem[])new Problem[]{missingAttribute});
        }
        if (expectedType.isInstance(value)) {
            return ResultOrProblems.of(expectedType.cast(value));
        }
        return ResultOrProblems.failed((Problem[])new Problem[]{TypeProblems.get().mismatch((Object)attribute, expectedType, value.getClass())});
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof H5Attribute)) {
            return false;
        }
        H5Attribute other = (H5Attribute)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        H5Type this$dataType = this.getDataType();
        H5Type other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !((Object)this$dataType).equals(other$dataType)) {
            return false;
        }
        H5Object this$parent = this.parent;
        H5Object other$parent = other.parent;
        return !(this$parent == null ? other$parent != null : !this$parent.equals(other$parent));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof H5Attribute;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        H5Type $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : ((Object)$dataType).hashCode());
        H5Object $parent = this.parent;
        result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
        return result;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public H5Type getDataType() {
        return this.dataType;
    }
}

