/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.beta;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nz.org.riskscape.config.BootstrapIniSettings;
import nz.org.riskscape.defaults.function.ListToTuple;
import nz.org.riskscape.defaults.function.SwitchFunction;
import nz.org.riskscape.defaults.function.expression.ExpressionFunctionFramework;
import nz.org.riskscape.defaults.interp.CreateBilinearContinuousFunction;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.Identified;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.defaults.function.LossesByPeriod;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.function.geometry.ToRelation;
import nz.org.riskscape.engine.function.lang.RemoveAttr;
import nz.org.riskscape.engine.output.GeoTiffFormat;
import nz.org.riskscape.engine.plugin.PluginDescriptor;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.problem.SeverityLevel;
import nz.org.riskscape.engine.rl.LanguageFunctions;
import nz.org.riskscape.engine.steps.SubpipelineStep;
import nz.org.riskscape.postgis.PostGISPipelineOutputStore;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;

public class Plugin
extends nz.org.riskscape.engine.plugin.Plugin {
    static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);

    public Plugin(PluginDescriptor pDescriptor) {
        super(pDescriptor);
        assert (pDescriptor.getPluginId().equals("beta")) : "Beta plugin has the wrong id";
    }

    public void startUp(Map<String, List<String>> settingsConfig, ProblemSink sink) {
        super.startUp(settingsConfig);
        BootstrapIniSettings settings = new BootstrapIniSettings(settingsConfig, sink);
    }

    public List<Problem> initializeEngine(Engine engine) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        problems.add(PROBLEMS.betaEnabled());
        engine.getPipelineOutputStores().add((Identified)new PostGISPipelineOutputStore());
        engine.getFunctionFrameworks().add((Identified)new ExpressionFunctionFramework());
        engine.getPipelineSteps().add((Identified)new SubpipelineStep(engine));
        engine.getFormats().add((Identified)new GeoTiffFormat());
        return problems;
    }

    public List<Problem> initializeProject(Project project, Engine engine) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        project.getFunctionSet().add((Identified)new SwitchFunction().builtin("switch", IdentifiedFunction.Category.LANGUAGE));
        project.getFunctionSet().add((Identified)new ListToTuple().builtin("list_to_tuple", IdentifiedFunction.Category.MISC));
        project.getFunctionSet().add((Identified)new LossesByPeriod().builtin("losses_by_period", IdentifiedFunction.Category.RISK_METRICS));
        project.getFunctionSet().add((Identified)new RemoveAttr().builtin("remove_attr", IdentifiedFunction.Category.LANGUAGE), nz.org.riskscape.engine.defaults.Plugin.DEFAULTS_SOURCE);
        project.getFunctionSet().add((Identified)LanguageFunctions.GET_ATTR);
        project.getFunctionSet().add((Identified)new ToRelation().builtin("to_relation", IdentifiedFunction.Category.GEOMETRY_PROCESSING), nz.org.riskscape.engine.defaults.Plugin.DEFAULTS_SOURCE);
        project.getFunctionSet().add((Identified)new CreateBilinearContinuousFunction().asFunction().builtin("create_continuous_2d", IdentifiedFunction.Category.MATHS));
        return problems;
    }

    static interface LocalProblems
    extends ProblemFactory {
        @SeverityLevel(value=Problem.Severity.WARNING)
        public Problem betaEnabled();
    }
}

