/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.jdbc.AutoGeneratedPrimaryKeyColumn;
import org.geotools.jdbc.BasicSQLDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.jdbc.SQLDialect;
import org.geotools.jdbc.SequencedPrimaryKeyColumn;

abstract class KeysFetcher {
    protected final PrimaryKey key;
    private final Set<String> columnNames;
    protected static Object NOT_SET_BEFORE_INSERT = new Object();

    protected KeysFetcher(PrimaryKey key) {
        this.key = key;
        this.columnNames = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(this.getColumnNames())));
    }

    public static KeysFetcher create(JDBCDataStore ds, Connection cx, boolean useExisting, PrimaryKey key) throws SQLException, IOException {
        if (useExisting) {
            return new Existing(ds.getSQLDialect(), key);
        }
        return new FromDB(ds, cx, key);
    }

    public int setKeyValues(PreparedStatementSQLDialect dialect, PreparedStatement ps, Connection cx, SimpleFeatureType featureType, SimpleFeature feature, int curFieldPos) throws IOException, SQLException {
        List<Object> keyValues = this.getNextValues(cx, feature);
        for (int i = 0; i < this.key.getColumns().size(); ++i) {
            PrimaryKeyColumn col = this.key.getColumns().get(i);
            Object value = keyValues.get(i);
            if (value == NOT_SET_BEFORE_INSERT) continue;
            dialect.setValue(value, col.getType(), ps, curFieldPos++, cx);
        }
        if (!this.isPostInsert()) {
            String fid = featureType.getTypeName() + "." + JDBCDataStore.encodeFID(keyValues);
            feature.getUserData().put("fid", fid);
        }
        return curFieldPos;
    }

    public void setKeyValues(JDBCDataStore ds, Connection cx, SimpleFeatureType featureType, SimpleFeature feature, StringBuffer sql) throws IOException, SQLException {
        BasicSQLDialect dialect = (BasicSQLDialect)ds.getSQLDialect();
        List<Object> keyValues = this.getNextValues(cx, feature);
        for (int i = 0; i < this.key.getColumns().size(); ++i) {
            PrimaryKeyColumn col = this.key.getColumns().get(i);
            Object value = keyValues.get(i);
            if (value == NOT_SET_BEFORE_INSERT) continue;
            try {
                dialect.encodeValue(value, col.getType(), sql);
                sql.append(",");
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (!this.isPostInsert()) {
            String fid = featureType.getTypeName() + "." + JDBCDataStore.encodeFID(keyValues);
            feature.getUserData().put("fid", fid);
        }
    }

    public abstract void addKeyColumns(StringBuffer var1);

    public abstract void addKeyBindings(StringBuffer var1);

    public abstract void postInsert(SimpleFeatureType var1, Collection<SimpleFeature> var2, PreparedStatement var3) throws SQLException;

    public abstract void postInsert(SimpleFeatureType var1, SimpleFeature var2, Connection var3, Statement var4) throws SQLException;

    public abstract boolean isPostInsert();

    public boolean hasAutoGeneratedKeys() {
        return false;
    }

    protected abstract List<Object> getNextValues(Connection var1, SimpleFeature var2) throws IOException, SQLException;

    public boolean isKey(String name) {
        return this.columnNames.contains(name);
    }

    public String[] getColumnNames() {
        String[] ret = new String[this.key.getColumns().size()];
        int i = 0;
        for (PrimaryKeyColumn col : this.key.getColumns()) {
            ret[i++] = col.getName();
        }
        return ret;
    }

    private static class FromSequence
    extends KeyFetcher {
        private final JDBCDataStore ds;

        public FromSequence(JDBCDataStore ds, PrimaryKeyColumn col) {
            super(ds, col);
            this.ds = ds;
        }

        @Override
        public void addKeyBinding(StringBuffer sql) {
            if (this.isPostInsert()) {
                String sequenceName = ((SequencedPrimaryKeyColumn)this.col).getSequenceName();
                sql.append(this.ds.getSQLDialect().encodeNextSequenceValue(null, sequenceName));
                sql.append(",");
            } else {
                super.addKeyBinding(sql);
            }
        }

        @Override
        public Object getLastValue(Connection cx, Statement st) throws SQLException {
            throw new IllegalArgumentException("Column " + this.col.getName() + " is not generated.");
        }

        @Override
        public boolean isPostInsert() {
            return this.ds.getSQLDialect().lookupGeneratedValuesPostInsert() && this.ds.getSQLDialect() instanceof PreparedStatementSQLDialect;
        }

        @Override
        public Object getNext(Connection cx) throws IOException, SQLException {
            if (this.isPostInsert()) {
                return NOT_SET_BEFORE_INSERT;
            }
            String sequenceName = ((SequencedPrimaryKeyColumn)this.col).getSequenceName();
            return this.ds.getSQLDialect().getNextSequenceValue(this.ds.getDatabaseSchema(), sequenceName, cx);
        }
    }

    private static class AutoGenerated
    extends KeyFetcher {
        private final JDBCDataStore ds;
        private final PrimaryKey key;

        public AutoGenerated(JDBCDataStore ds, PrimaryKey key, PrimaryKeyColumn col) {
            super(ds, col);
            this.ds = ds;
            this.key = key;
        }

        @Override
        public Object getNext(Connection cx) throws IOException, SQLException {
            if (this.isPostInsert()) {
                return NOT_SET_BEFORE_INSERT;
            }
            return this.ds.getSQLDialect().getNextAutoGeneratedValue(this.ds.getDatabaseSchema(), this.key.getTableName(), this.col.getName(), cx);
        }

        @Override
        public void addKeyColumn(StringBuffer sql) {
            if (!this.isPostInsert()) {
                super.addKeyColumn(sql);
            }
        }

        @Override
        public void addKeyBinding(StringBuffer sql) {
            if (!this.isPostInsert()) {
                super.addKeyBinding(sql);
            }
        }

        @Override
        public Object getLastValue(Connection cx, Statement st) throws SQLException {
            return this.ds.getSQLDialect().getLastAutoGeneratedValue(this.ds.getDatabaseSchema(), this.key.getTableName(), this.col.getName(), cx, st);
        }

        @Override
        public boolean isPostInsert() {
            return this.ds.getSQLDialect().lookupGeneratedValuesPostInsert();
        }

        @Override
        public boolean isAutoGenerated() {
            return this.isPostInsert();
        }
    }

    protected static class FromPreviousIntegral
    extends KeyFetcher {
        private Object next;

        public FromPreviousIntegral(JDBCDataStore ds, Connection cx, PrimaryKey key, PrimaryKeyColumn col) throws SQLException {
            super(ds, col);
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT MAX(");
            ds.getSQLDialect().encodeColumnName(null, col.getName(), sql);
            sql.append(") + 1 FROM ");
            ds.encodeTableName(key.getTableName(), sql, null);
            try (Statement st = cx.createStatement();
                 ResultSet rs = st.executeQuery(sql.toString());){
                this.next = rs.next() ? rs.getObject(1) : Integer.valueOf(1);
                if (this.next == null) {
                    this.next = 1;
                }
            }
        }

        @Override
        public Object getNext(Connection cx) throws IOException {
            Object result = this.next;
            this.next = FromPreviousIntegral.increment(this.next);
            return result;
        }

        @Override
        public Object getLastValue(Connection cx, Statement st) {
            throw new IllegalArgumentException("Column " + this.col.getName() + " is not generated.");
        }

        @Override
        public boolean isPostInsert() {
            return false;
        }

        public static Object increment(Object value) throws IOException {
            if (value instanceof Integer) {
                return (Integer)value + 1;
            }
            if (value instanceof Long) {
                return (Long)value + 1L;
            }
            if (value instanceof Short) {
                return (short)((Short)value + 1);
            }
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).add(BigDecimal.ONE);
            }
            if (value instanceof BigInteger) {
                return ((BigInteger)value).add(BigInteger.ONE);
            }
            throw new IOException("Don't know how to increment a number of class " + value.getClass().getSimpleName());
        }
    }

    private static class FromUuid
    extends KeyFetcher {
        FromUuid(JDBCDataStore ds, PrimaryKeyColumn col) {
            super(ds, col);
        }

        @Override
        public Object getLastValue(Connection cx, Statement st) {
            throw new IllegalArgumentException("Column " + this.col.getName() + " is not generated.");
        }

        @Override
        public boolean isPostInsert() {
            return false;
        }

        @Override
        public Object getNext(Connection cx) {
            return UUID.randomUUID();
        }
    }

    private static class FromRandom
    extends KeyFetcher {
        FromRandom(JDBCDataStore ds, PrimaryKeyColumn col) {
            super(ds, col);
        }

        @Override
        public Object getLastValue(Connection cx, Statement st) {
            throw new IllegalArgumentException("Column " + this.col.getName() + " is not generated.");
        }

        @Override
        public boolean isPostInsert() {
            return false;
        }

        @Override
        public Object getNext(Connection cx) {
            return SimpleFeatureBuilder.createDefaultFeatureId();
        }
    }

    private static abstract class KeyFetcher {
        private final String colName;
        protected final PrimaryKeyColumn col;

        public abstract Object getNext(Connection var1) throws IOException, SQLException;

        KeyFetcher(JDBCDataStore ds, PrimaryKeyColumn col) {
            this.col = col;
            StringBuffer colName = new StringBuffer();
            ds.getSQLDialect().encodeColumnName(null, col.getName(), colName);
            this.colName = colName.toString();
        }

        public void addKeyColumn(StringBuffer sql) {
            sql.append(this.colName);
            sql.append(",");
        }

        public void addKeyBinding(StringBuffer sql) {
            sql.append("?,");
        }

        public abstract Object getLastValue(Connection var1, Statement var2) throws SQLException;

        public Object getLastValue(Connection cx) throws SQLException {
            return this.getLastValue(cx, null);
        }

        public abstract boolean isPostInsert();

        public boolean isAutoGenerated() {
            return false;
        }
    }

    private static class FromDB
    extends KeysFetcher {
        private final List<KeyFetcher> fetchers;

        public FromDB(JDBCDataStore ds, Connection cx, PrimaryKey key) throws SQLException, IOException {
            super(key);
            this.fetchers = new ArrayList<KeyFetcher>(key.getColumns().size());
            for (PrimaryKeyColumn col : key.getColumns()) {
                this.fetchers.add(this.createKeyFetcher(ds, cx, key, col));
            }
        }

        private KeyFetcher createKeyFetcher(JDBCDataStore ds, Connection cx, PrimaryKey key, PrimaryKeyColumn col) throws SQLException, IOException {
            Class t = col.getType();
            if (col instanceof AutoGeneratedPrimaryKeyColumn) {
                return new AutoGenerated(ds, key, col);
            }
            if (col instanceof SequencedPrimaryKeyColumn) {
                return new FromSequence(ds, col);
            }
            if (Number.class.isAssignableFrom(t)) {
                if (t == Short.class || t == Integer.class || t == Long.class || BigInteger.class.isAssignableFrom(t) || BigDecimal.class.isAssignableFrom(t)) {
                    return new FromPreviousIntegral(ds, cx, key, col);
                }
            } else {
                if (CharSequence.class.isAssignableFrom(t)) {
                    return new FromRandom(ds, col);
                }
                if (t == UUID.class) {
                    return new FromUuid(ds, col);
                }
            }
            throw new IOException("Cannot generate key value for column of type: " + t.getName());
        }

        @Override
        public void addKeyColumns(StringBuffer sql) {
            for (KeyFetcher fetcher : this.fetchers) {
                fetcher.addKeyColumn(sql);
            }
        }

        @Override
        public void addKeyBindings(StringBuffer sql) {
            for (KeyFetcher fetcher : this.fetchers) {
                fetcher.addKeyBinding(sql);
            }
        }

        @Override
        public void postInsert(SimpleFeatureType featureType, Collection<SimpleFeature> features, PreparedStatement ps) throws SQLException {
            if (!this.isPostInsert()) {
                return;
            }
            try (ResultSet rs = ps.getGeneratedKeys();){
                Iterator<SimpleFeature> it = features.iterator();
                ArrayList<Object> keyValues = new ArrayList<Object>(this.key.getColumns().size());
                while (rs.next()) {
                    SimpleFeature feature = it.next();
                    for (int index = 1; index <= this.key.getColumns().size(); ++index) {
                        keyValues.add(rs.getObject(index));
                    }
                    String fid = featureType.getTypeName() + "." + JDBCDataStore.encodeFID(keyValues);
                    feature.getUserData().put("fid", fid);
                    keyValues.clear();
                }
            }
        }

        @Override
        public void postInsert(SimpleFeatureType featureType, SimpleFeature feature, Connection cx, Statement st) throws SQLException {
            if (!this.isPostInsert()) {
                return;
            }
            List<Object> keyValues = this.getLastValues(cx, st);
            String fid = featureType.getTypeName() + "." + JDBCDataStore.encodeFID(keyValues);
            feature.getUserData().put("fid", fid);
        }

        @Override
        public boolean isPostInsert() {
            for (KeyFetcher fetcher : this.fetchers) {
                if (!fetcher.isPostInsert()) continue;
                return true;
            }
            return false;
        }

        private List<Object> getLastValues(Connection cx, Statement st) throws SQLException {
            ArrayList<Object> last = new ArrayList<Object>();
            for (KeyFetcher fetcher : this.fetchers) {
                last.add(fetcher.getLastValue(cx, st));
            }
            return last;
        }

        @Override
        public List<Object> getNextValues(Connection cx, SimpleFeature feature) throws IOException, SQLException {
            ArrayList<Object> ret = new ArrayList<Object>(this.fetchers.size());
            for (KeyFetcher fetcher : this.fetchers) {
                ret.add(fetcher.getNext(cx));
            }
            return ret;
        }

        @Override
        public boolean hasAutoGeneratedKeys() {
            for (KeyFetcher fetcher : this.fetchers) {
                if (!fetcher.isAutoGenerated()) continue;
                return true;
            }
            return false;
        }
    }

    private static class Existing
    extends KeysFetcher {
        private final String keyColumnNames;

        public Existing(SQLDialect dialect, PrimaryKey key) {
            super(key);
            StringBuffer keyColumnNames = new StringBuffer();
            for (PrimaryKeyColumn col : key.getColumns()) {
                dialect.encodeColumnName(null, col.getName(), keyColumnNames);
                keyColumnNames.append(",");
            }
            this.keyColumnNames = keyColumnNames.toString();
        }

        @Override
        public void addKeyColumns(StringBuffer sql) {
            sql.append(this.keyColumnNames);
        }

        @Override
        public void addKeyBindings(StringBuffer sql) {
            for (int i = 0; i < this.key.getColumns().size(); ++i) {
                sql.append("?,");
            }
        }

        @Override
        public void postInsert(SimpleFeatureType featureType, Collection<SimpleFeature> features, PreparedStatement ps) {
        }

        @Override
        public void postInsert(SimpleFeatureType featureType, SimpleFeature feature, Connection cx, Statement st) throws SQLException {
        }

        @Override
        public boolean isPostInsert() {
            return false;
        }

        @Override
        public List<Object> getNextValues(Connection cx, SimpleFeature feature) {
            return JDBCDataStore.decodeFID(this.key, feature.getID(), true);
        }
    }
}

