/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.geotools.util.factory.Hints;

public class Index {
    String typeName;
    String indexName;
    boolean unique;
    List<String> attributes;
    Hints hints;

    public Index(String typeName, String indexName, boolean unique, String ... attributes) {
        this.typeName = typeName;
        this.indexName = indexName;
        this.attributes = new ArrayList<String>(Arrays.asList(attributes));
        this.unique = unique;
    }

    public Index(String typeName, String indexName, boolean unique, Hints hints, String ... attributes) {
        this.typeName = typeName;
        this.indexName = indexName;
        this.hints = hints;
        this.attributes = new ArrayList<String>(Arrays.asList(attributes));
        this.unique = unique;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public List<String> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public Hints getHints() {
        return this.hints;
    }

    public String toString() {
        return "Index [typeName=" + this.typeName + ", indexName=" + this.indexName + ", unique=" + this.unique + ", attributes=" + this.attributes + ", hints=" + this.hints + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.hints == null ? 0 : this.hints.hashCode());
        result = 31 * result + (this.indexName == null ? 0 : this.indexName.hashCode());
        result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
        result = 31 * result + (this.unique ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Index other = (Index)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.hints == null ? other.hints != null : !this.hints.equals((Object)other.hints)) {
            return false;
        }
        if (this.indexName == null ? other.indexName != null : !this.indexName.equals(other.indexName)) {
            return false;
        }
        if (this.typeName == null ? other.typeName != null : !this.typeName.equals(other.typeName)) {
            return false;
        }
        return this.unique == other.unique;
    }
}

