/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public class ListUtils {
    public static <T> List<T> concat(List<? extends T> list1, List<? extends T> list2) {
        if (list1.isEmpty()) {
            return list2;
        }
        if (list2.isEmpty()) {
            return list1;
        }
        ArrayList<T> newList = new ArrayList<T>(list1.size() + list2.size());
        newList.addAll(list1);
        newList.addAll(list2);
        return newList;
    }

    public static <T> List<T> append(List<? extends T> list, T element) {
        if (list.isEmpty()) {
            return Collections.singletonList(element);
        }
        ArrayList<T> newList = new ArrayList<T>(list.size() + 1);
        newList.addAll(list);
        newList.add(element);
        return newList;
    }

    public static <T> List<T> prepend(T element, List<? extends T> list) {
        if (list.isEmpty()) {
            return Collections.singletonList(element);
        }
        ArrayList<T> newList = new ArrayList<T>(list.size() + 1);
        newList.add(element);
        newList.addAll(list);
        return newList;
    }

    @SafeVarargs
    public static <T> List<T> prepend(@NonNull T element, T ... rest) {
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        if (rest.length == 0) {
            return Collections.singletonList(element);
        }
        ArrayList<T> newList = new ArrayList<T>(rest.length + 1);
        newList.add(element);
        for (int i = 0; i < rest.length; ++i) {
            newList.add(rest[i]);
        }
        return newList;
    }
}

