/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.rl.ast;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.Generated;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.rl.TokenTypes;
import nz.org.riskscape.rl.ast.BaseExpr;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ExpressionVisitor;
import nz.org.riskscape.rl.ast.PropertyAccess;
import nz.org.riskscape.rl.ast.SelectAllExpression;

public class StructDeclaration
extends BaseExpr {
    private final List<Member> members;
    private final Optional<Pair<Token, Token>> boundary;

    public static Member anonMember(Expression expression) {
        return new Member(null, expression, null);
    }

    public static Member jsonStyleMember(Token ident, Expression expression) {
        return new Member(ident, expression, null);
    }

    public static Member jsonStyleMember(String ident, Expression expression) {
        return new Member(TokenTypes.identToken(ident), expression, null);
    }

    public static Member sqlStyleMember(Token ident, Expression expression, Token as) {
        return new Member(ident, expression, as);
    }

    public static Member selectAllMember(Token asterisk) {
        return new Member(asterisk, new SelectAllExpression(asterisk), null);
    }

    @Override
    protected void appendSource(StringBuilder appendTo) {
        StructDeclaration.join(appendTo, this.members, (sb, m) -> m.appendSource((StringBuilder)sb), ", ", "{", "}");
    }

    @Override
    public <T, R> R accept(ExpressionVisitor<T, R> visitor, T data) {
        return visitor.visit(this, data);
    }

    public Member getMember(int index) {
        return this.getMembers().get(index);
    }

    public StructDeclaration withNewMembers(List<Member> newMembers, Optional<Pair<Token, Token>> newBoundary) {
        return new StructDeclaration(newMembers, newBoundary);
    }

    @Generated
    public StructDeclaration(List<Member> members, Optional<Pair<Token, Token>> boundary) {
        this.members = members;
        this.boundary = boundary;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StructDeclaration)) {
            return false;
        }
        StructDeclaration other = (StructDeclaration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Member> this$members = this.getMembers();
        List<Member> other$members = other.getMembers();
        if (this$members == null ? other$members != null : !((Object)this$members).equals(other$members)) {
            return false;
        }
        Optional<Pair<Token, Token>> this$boundary = this.getBoundary();
        Optional<Pair<Token, Token>> other$boundary = other.getBoundary();
        return !(this$boundary == null ? other$boundary != null : !((Object)this$boundary).equals(other$boundary));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StructDeclaration;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Member> $members = this.getMembers();
        result = result * 59 + ($members == null ? 43 : ((Object)$members).hashCode());
        Optional<Pair<Token, Token>> $boundary = this.getBoundary();
        result = result * 59 + ($boundary == null ? 43 : ((Object)$boundary).hashCode());
        return result;
    }

    @Generated
    public List<Member> getMembers() {
        return this.members;
    }

    @Override
    @Generated
    public Optional<Pair<Token, Token>> getBoundary() {
        return this.boundary;
    }

    public static class Member {
        @Nullable
        private final Token identifier;
        private final Expression expression;
        private final boolean selectAll;
        private final boolean selectAllOnReceiver;
        @Nullable
        private final Token as;

        private Member(Token ident, Expression expression, Token asToken) {
            this.identifier = ident;
            this.expression = expression;
            this.selectAll = expression instanceof SelectAllExpression && this.identifier != null && this.identifier.type == TokenTypes.MULTIPLY;
            this.selectAllOnReceiver = expression.isA(PropertyAccess.class).map(PropertyAccess::isTrailingSelectAll).orElse(false);
            this.as = asToken;
        }

        public Optional<String> getName() {
            return this.identifier == null ? Optional.empty() : Optional.of(this.identifier.getValue());
        }

        @Deprecated
        public String getAttributeName() {
            if (this.identifier != null) {
                return this.identifier.getValue();
            }
            return this.expression.toSource().replaceAll("\\.", "_");
        }

        public void appendSource(StringBuilder appendTo) {
            if (this.isJSONStyle()) {
                appendTo.append(this.identifier.rawValue()).append(": ");
            }
            if (this.isSelectAll()) {
                appendTo.append(this.identifier.rawValue());
            } else {
                BaseExpr.wrap(this.expression).appendSource(appendTo);
            }
            if (this.isSQLStyle()) {
                appendTo.append(" as ").append(this.identifier.rawValue());
            }
        }

        public Member cloneWithExpression(Expression newExpression) {
            return new Member(this.getIdentifier(), newExpression, this.as);
        }

        public String toSource() {
            StringBuilder sb = new StringBuilder();
            this.appendSource(sb);
            return sb.toString();
        }

        public boolean isAnonymous() {
            return this.identifier == null;
        }

        public boolean isSQLStyle() {
            return this.as != null;
        }

        public boolean isJSONStyle() {
            return !this.isAnonymous() && !this.isSelectAll() && !this.isSQLStyle();
        }

        @Nullable
        @Generated
        public Token getIdentifier() {
            return this.identifier;
        }

        @Generated
        public Expression getExpression() {
            return this.expression;
        }

        @Generated
        public boolean isSelectAll() {
            return this.selectAll;
        }

        @Generated
        public boolean isSelectAllOnReceiver() {
            return this.selectAllOnReceiver;
        }

        @Nullable
        @Generated
        public Token getAs() {
            return this.as;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Member)) {
                return false;
            }
            Member other = (Member)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSelectAll() != other.isSelectAll()) {
                return false;
            }
            if (this.isSelectAllOnReceiver() != other.isSelectAllOnReceiver()) {
                return false;
            }
            Token this$identifier = this.getIdentifier();
            Token other$identifier = other.getIdentifier();
            if (this$identifier == null ? other$identifier != null : !((Object)this$identifier).equals(other$identifier)) {
                return false;
            }
            Expression this$expression = this.getExpression();
            Expression other$expression = other.getExpression();
            if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
                return false;
            }
            Token this$as = this.getAs();
            Token other$as = other.getAs();
            return !(this$as == null ? other$as != null : !((Object)this$as).equals(other$as));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Member;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSelectAll() ? 79 : 97);
            result = result * 59 + (this.isSelectAllOnReceiver() ? 79 : 97);
            Token $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : ((Object)$identifier).hashCode());
            Expression $expression = this.getExpression();
            result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
            Token $as = this.getAs();
            result = result * 59 + ($as == null ? 43 : ((Object)$as).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "StructDeclaration.Member(identifier=" + String.valueOf(this.getIdentifier()) + ", expression=" + String.valueOf(this.getExpression()) + ", selectAll=" + this.isSelectAll() + ", selectAllOnReceiver=" + this.isSelectAllOnReceiver() + ", as=" + String.valueOf(this.getAs()) + ")";
        }
    }
}

