/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.rl.ast;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.rl.TokenTypes;
import nz.org.riskscape.rl.ast.BaseExpr;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ExpressionVisitor;

public final class PropertyAccess
extends BaseExpr {
    private final Optional<Expression> receiver;
    private final List<Token> identifiers;

    public static PropertyAccess of(String ... identifiers) {
        return PropertyAccess.of(Arrays.asList(identifiers));
    }

    public static PropertyAccess of(List<String> identifiers) {
        ArrayList tokens = Lists.newArrayList();
        for (String identifier : identifiers) {
            tokens.add(Token.token(TokenTypes.IDENTIFIER, identifier));
        }
        return new PropertyAccess(Optional.empty(), tokens);
    }

    public PropertyAccess and(String additionalPath) {
        ArrayList newIdentifiers = Lists.newArrayList(this.identifiers);
        newIdentifiers.add(Token.token(TokenTypes.IDENTIFIER, additionalPath));
        return new PropertyAccess(this.receiver, newIdentifiers);
    }

    @Override
    protected void appendSource(StringBuilder appendTo) {
        this.receiver.ifPresent(r -> {
            PropertyAccess.wrap(r).appendSource(appendTo);
            appendTo.append(".");
        });
        PropertyAccess.join(appendTo, this.identifiers, (sb, t) -> sb.append(t.rawValue()), ".", "", "");
    }

    public String getAccessString() {
        return this.identifiers.stream().map(t -> t.value).collect(Collectors.joining("."));
    }

    public Token getFirstIdentifier() {
        return this.identifiers.get(0);
    }

    public Token getLastIdentifier() {
        return this.identifiers.get(this.identifiers.size() - 1);
    }

    public boolean isSingleIdentifier() {
        return !this.receiver.isPresent() && this.identifiers.size() == 1;
    }

    @Override
    public <T, R> R accept(ExpressionVisitor<T, R> visitor, T data) {
        return visitor.visit(this, data);
    }

    @Override
    public Optional<Pair<Token, Token>> getBoundary() {
        return Optional.of(Pair.of(this.getReceiver().flatMap(r -> r.getBoundary().map(Pair::getLeft)).orElse(this.getFirstIdentifier()), this.getLastIdentifier()));
    }

    public boolean isTrailingSelectAll() {
        return this.getIdentifiers().get(this.getIdentifiers().size() - 1).getValue().equals("*");
    }

    public boolean isReceiverSelectAll() {
        return this.receiver.isPresent() && this.identifiers.size() == 1 && this.getFirstIdentifier().getValue().equals("*");
    }

    @Generated
    public PropertyAccess(Optional<Expression> receiver, List<Token> identifiers) {
        this.receiver = receiver;
        this.identifiers = identifiers;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyAccess)) {
            return false;
        }
        PropertyAccess other = (PropertyAccess)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Optional<Expression> this$receiver = this.getReceiver();
        Optional<Expression> other$receiver = other.getReceiver();
        if (this$receiver == null ? other$receiver != null : !((Object)this$receiver).equals(other$receiver)) {
            return false;
        }
        List<Token> this$identifiers = this.getIdentifiers();
        List<Token> other$identifiers = other.getIdentifiers();
        return !(this$identifiers == null ? other$identifiers != null : !((Object)this$identifiers).equals(other$identifiers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PropertyAccess;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<Expression> $receiver = this.getReceiver();
        result = result * 59 + ($receiver == null ? 43 : ((Object)$receiver).hashCode());
        List<Token> $identifiers = this.getIdentifiers();
        result = result * 59 + ($identifiers == null ? 43 : ((Object)$identifiers).hashCode());
        return result;
    }

    @Generated
    public Optional<Expression> getReceiver() {
        return this.receiver;
    }

    @Generated
    public List<Token> getIdentifiers() {
        return this.identifiers;
    }
}

