/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.rl.ast;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.rl.TokenTypes;
import nz.org.riskscape.rl.ast.BaseExpr;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ExpressionVisitor;

public class Lambda
extends BaseExpr {
    private final Token left;
    private final List<Token> arguments;
    private final Expression expression;

    @Override
    public Optional<Pair<Token, Token>> getBoundary() {
        return Optional.of(Pair.of(this.left, this.expression.getBoundary().get().getRight()));
    }

    @Override
    public <T, R> R accept(ExpressionVisitor<T, R> visitor, T data) {
        return visitor.visit(this, data);
    }

    @Override
    protected void appendSource(StringBuilder appendTo) {
        boolean useBrackets = this.left.type != TokenTypes.IDENTIFIER;
        Lambda.join(appendTo, this.arguments, (sb, a) -> sb.append(a.rawValue()), ", ", useBrackets ? "(" : "", useBrackets ? ")" : "");
        appendTo.append(" -> ");
        Lambda.wrap(this.expression).appendSource(appendTo);
    }

    @Generated
    public Lambda(Token left, List<Token> arguments, Expression expression) {
        this.left = left;
        this.arguments = arguments;
        this.expression = expression;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Lambda)) {
            return false;
        }
        Lambda other = (Lambda)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Token this$left = this.getLeft();
        Token other$left = other.getLeft();
        if (this$left == null ? other$left != null : !((Object)this$left).equals(other$left)) {
            return false;
        }
        List<Token> this$arguments = this.getArguments();
        List<Token> other$arguments = other.getArguments();
        if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
            return false;
        }
        Expression this$expression = this.getExpression();
        Expression other$expression = other.getExpression();
        return !(this$expression == null ? other$expression != null : !this$expression.equals(other$expression));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Lambda;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Token $left = this.getLeft();
        result = result * 59 + ($left == null ? 43 : ((Object)$left).hashCode());
        List<Token> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        Expression $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        return result;
    }

    @Generated
    public Token getLeft() {
        return this.left;
    }

    @Generated
    public List<Token> getArguments() {
        return this.arguments;
    }

    @Generated
    public Expression getExpression() {
        return this.expression;
    }
}

