/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.rl.ast;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.TokenTypes;
import nz.org.riskscape.rl.ast.BaseExpr;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ExpressionVisitor;

public final class FunctionCall
extends BaseExpr {
    private final Token identifier;
    private final List<Argument> arguments;
    private final Optional<Pair<Token, Token>> boundary;

    public FunctionCall(Token identifier, List<Argument> arguments, Token closing) {
        this(identifier, arguments, Optional.of(Pair.of(identifier, closing)));
    }

    public FunctionCall(Token identifier, List<Argument> arguments) {
        this(identifier, arguments, Optional.empty());
    }

    @Override
    protected void appendSource(StringBuilder appendTo) {
        appendTo.append(this.identifier.rawValue());
        FunctionCall.join(appendTo, this.arguments, (sb, a) -> a.appendSource((StringBuilder)sb), ", ", "(", ")");
    }

    public int keywordArgumentsOffset() {
        int i;
        for (i = 0; i < this.arguments.size() && !this.arguments.get(i).getName().isPresent(); ++i) {
        }
        return i;
    }

    public boolean hasKeywordArguments() {
        return this.keywordArgumentsOffset() < this.arguments.size();
    }

    public int indexOfArgNamed(String toFind) {
        for (int i = 0; i < this.arguments.size(); ++i) {
            Argument arg = this.arguments.get(i);
            if (!arg.getName().map(name -> name.equals(toFind)).orElse(false).booleanValue()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public <T, R> R accept(ExpressionVisitor<T, R> visitor, T data) {
        return visitor.visit(this, data);
    }

    public List<Argument> getPositionalArguments() {
        ArrayList<Argument> positionals = new ArrayList<Argument>(this.arguments.size());
        for (Argument argument : this.arguments) {
            if (argument.getNameToken().isPresent()) {
                return positionals;
            }
            positionals.add(argument);
        }
        return positionals;
    }

    @Generated
    public FunctionCall(Token identifier, List<Argument> arguments, Optional<Pair<Token, Token>> boundary) {
        this.identifier = identifier;
        this.arguments = arguments;
        this.boundary = boundary;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionCall)) {
            return false;
        }
        FunctionCall other = (FunctionCall)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Token this$identifier = this.getIdentifier();
        Token other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !((Object)this$identifier).equals(other$identifier)) {
            return false;
        }
        List<Argument> this$arguments = this.getArguments();
        List<Argument> other$arguments = other.getArguments();
        return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FunctionCall;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Token $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : ((Object)$identifier).hashCode());
        List<Argument> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        return result;
    }

    @Generated
    public Token getIdentifier() {
        return this.identifier;
    }

    @Generated
    public List<Argument> getArguments() {
        return this.arguments;
    }

    @Override
    @Generated
    public Optional<Pair<Token, Token>> getBoundary() {
        return this.boundary;
    }

    public static final class Argument {
        private final Expression expression;
        private final Optional<Token> nameToken;

        public Argument(Expression expression, String keyword) {
            this(expression, Optional.of(Token.token(TokenTypes.KEY_IDENTIFIER, keyword)));
        }

        public Argument(Expression expression) {
            this(expression, Optional.empty());
        }

        public Optional<String> getName() {
            return this.getNameToken().map(Token::getValue);
        }

        public Optional<Token> getNameToken() {
            return this.nameToken;
        }

        public void appendSource(StringBuilder appendTo) {
            this.nameToken.ifPresent(nt -> appendTo.append(nt.getValue()).append(": "));
            BaseExpr.wrap(this.expression).appendSource(appendTo);
        }

        public boolean isKeywordArgument() {
            return this.nameToken.isPresent();
        }

        public String toSource() {
            return this.nameToken.map(t -> t.getValue() + ": ").orElse("") + this.expression.toSource();
        }

        public <T> ResultOrProblems<T> evaluateConstant(RealizationContext context, Class<T> requiredJavaType, Type requiredType) {
            return context.getExpressionRealizer().realizeConstant(this.expression).flatMap(realized -> {
                if (!requiredJavaType.isAssignableFrom(realized.getResultType().internalType())) {
                    return ResultOrProblems.failed(TypeProblems.get().mismatch((Object)this.expression, requiredType, realized.getResultType()));
                }
                Object returned = realized.evaluate(Tuple.EMPTY_TUPLE);
                return ResultOrProblems.of(requiredJavaType.cast(returned));
            });
        }

        @Generated
        public Expression getExpression() {
            return this.expression;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Argument)) {
                return false;
            }
            Argument other = (Argument)o;
            Expression this$expression = this.getExpression();
            Expression other$expression = other.getExpression();
            if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
                return false;
            }
            Optional<Token> this$nameToken = this.getNameToken();
            Optional<Token> other$nameToken = other.getNameToken();
            return !(this$nameToken == null ? other$nameToken != null : !((Object)this$nameToken).equals(other$nameToken));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Expression $expression = this.getExpression();
            result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
            Optional<Token> $nameToken = this.getNameToken();
            result = result * 59 + ($nameToken == null ? 43 : ((Object)$nameToken).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FunctionCall.Argument(expression=" + String.valueOf(this.getExpression()) + ", nameToken=" + String.valueOf(this.getNameToken()) + ")";
        }

        @Generated
        public Argument(Expression expression, Optional<Token> nameToken) {
            this.expression = expression;
            this.nameToken = nameToken;
        }
    }
}

