/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.rl.ast;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import nz.org.riskscape.rl.ast.BinaryOperation;
import nz.org.riskscape.rl.ast.BracketedExpression;
import nz.org.riskscape.rl.ast.Constant;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ExpressionVisitor;
import nz.org.riskscape.rl.ast.FunctionCall;
import nz.org.riskscape.rl.ast.Lambda;
import nz.org.riskscape.rl.ast.ListDeclaration;
import nz.org.riskscape.rl.ast.ParameterToken;
import nz.org.riskscape.rl.ast.PropertyAccess;
import nz.org.riskscape.rl.ast.SelectAllExpression;
import nz.org.riskscape.rl.ast.StructDeclaration;

public class ExpressionConverter<T>
implements ExpressionVisitor<T, Expression> {
    @Override
    public Expression visit(BinaryOperation expression, T data) {
        return new BinaryOperation((Expression)expression.getLhs().accept(this, data), expression.getOperator(), (Expression)expression.getRhs().accept(this, data));
    }

    @Override
    public Expression visit(BracketedExpression expression, T data) {
        return new BracketedExpression((Expression)expression.getExpression().accept(this, data), expression.getBoundary());
    }

    @Override
    public Expression visit(Constant expression, T data) {
        return expression;
    }

    @Override
    public Expression visit(FunctionCall expression, T data) {
        List<FunctionCall.Argument> convertedArgs = expression.getArguments().stream().map(a -> new FunctionCall.Argument((Expression)a.getExpression().accept(this, data), a.getNameToken())).collect(Collectors.toList());
        return new FunctionCall(expression.getIdentifier(), convertedArgs, expression.getBoundary());
    }

    @Override
    public Expression visit(ListDeclaration expression, T data) {
        List<Expression> converted = expression.getElements().stream().map(e -> (Expression)e.accept(this, data)).collect(Collectors.toList());
        return new ListDeclaration(converted, expression.getBoundary());
    }

    @Override
    public Expression visit(PropertyAccess expression, T data) {
        return new PropertyAccess(expression.getReceiver().map(r -> (Expression)r.accept(this, data)), expression.getIdentifiers());
    }

    @Override
    public Expression visit(StructDeclaration expression, T data) {
        ArrayList<StructDeclaration.Member> mappedMembers = new ArrayList<StructDeclaration.Member>();
        for (StructDeclaration.Member member : expression.getMembers()) {
            mappedMembers.add(member.cloneWithExpression((Expression)member.getExpression().accept(this, data)));
        }
        return expression.withNewMembers(mappedMembers, expression.getBoundary());
    }

    @Override
    public Expression visit(SelectAllExpression expression, T data) {
        return expression;
    }

    @Override
    public Expression visit(Lambda expression, T data) {
        return new Lambda(expression.getLeft(), expression.getArguments(), (Expression)expression.getExpression().accept(this, data));
    }

    @Override
    public Expression visit(ParameterToken parameterToken, T data) {
        return parameterToken;
    }
}

