/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.rl.ast;

import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.rl.TokenTypes;
import nz.org.riskscape.rl.ast.BaseExpr;
import nz.org.riskscape.rl.ast.ExpressionVisitor;

public final class Constant
extends BaseExpr {
    public static final Constant TRUE = new Constant(Token.token(TokenTypes.KEYWORD_TRUE, "true"));
    public static final Constant FALSE = new Constant(Token.token(TokenTypes.KEYWORD_FALSE, "false"));
    private final Token token;

    public static Constant string(String text) {
        return new Constant(Token.token(TokenTypes.STRING, text));
    }

    public static Constant integer(long value) {
        return new Constant(Token.token(TokenTypes.INTEGER, Long.toString(value)));
    }

    public static Constant floating(double value) {
        return new Constant(Token.token(TokenTypes.DECIMAL, Double.toString(value)));
    }

    @Override
    protected void appendSource(StringBuilder appendTo) {
        appendTo.append(this.token.rawValue());
    }

    @Override
    public <T, R> R accept(ExpressionVisitor<T, R> visitor, T data) {
        return visitor.visit(this, data);
    }

    @Override
    public Optional<Pair<Token, Token>> getBoundary() {
        return Optional.of(Pair.of(this.token, this.token));
    }

    @Generated
    public Constant(Token token) {
        this.token = token;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Constant)) {
            return false;
        }
        Constant other = (Constant)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Token this$token = this.getToken();
        Token other$token = other.getToken();
        return !(this$token == null ? other$token != null : !((Object)this$token).equals(other$token));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Constant;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Token $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : ((Object)$token).hashCode());
        return result;
    }

    @Generated
    public Token getToken() {
        return this.token;
    }
}

