/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.rl.ast;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.rl.TokenTypes;
import nz.org.riskscape.rl.ast.BaseExpr;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ExpressionVisitor;

public class BinaryOperation
extends BaseExpr {
    public static final Map<TokenTypes, TokenTypes> NORMALIZED_TOKENS = ImmutableMap.of((Object)TokenTypes.KEYWORD_AND, (Object)TokenTypes.AND, (Object)TokenTypes.KEYWORD_OR, (Object)TokenTypes.OR);
    public static final List<EnumSet<?>> PRIORITY = ImmutableList.of(EnumSet.of(TokenTypes.POW), EnumSet.of(TokenTypes.DIVIDE), EnumSet.of(TokenTypes.MULTIPLY), EnumSet.of(TokenTypes.PLUS), EnumSet.of(TokenTypes.MINUS), EnumSet.of(TokenTypes.EQUALS, new TokenTypes[]{TokenTypes.NOT_EQUALS, TokenTypes.LESS_THAN_EQUAL, TokenTypes.GREATER_THAN_EQUAL, TokenTypes.LESS_THAN, TokenTypes.GREATER_THAN}), EnumSet.of(TokenTypes.AND, TokenTypes.KEYWORD_AND, TokenTypes.OR, TokenTypes.KEYWORD_OR));
    private final Expression lhs;
    private final Token operator;
    private final Expression rhs;

    @Override
    protected void appendSource(StringBuilder appendTo) {
        BinaryOperation.wrap(this.lhs).appendSource(appendTo);
        appendTo.append(" ").append(this.operator.rawValue()).append(" ");
        BinaryOperation.wrap(this.rhs).appendSource(appendTo);
    }

    public TokenTypes getNormalizedOperator() {
        TokenTypes tt = (TokenTypes)this.operator.type;
        return NORMALIZED_TOKENS.getOrDefault(tt, tt);
    }

    @Override
    public <T, R> R accept(ExpressionVisitor<T, R> visitor, T data) {
        return visitor.visit(this, data);
    }

    @Override
    public Optional<Pair<Token, Token>> getBoundary() {
        if (this.getLhs().getBoundary().isPresent() && this.getRhs().getBoundary().isPresent()) {
            return Optional.of(Pair.of(this.getLhs().getBoundary().get().getLeft(), this.getRhs().getBoundary().get().getRight()));
        }
        return Optional.empty();
    }

    @Generated
    public BinaryOperation(Expression lhs, Token operator, Expression rhs) {
        this.lhs = lhs;
        this.operator = operator;
        this.rhs = rhs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BinaryOperation)) {
            return false;
        }
        BinaryOperation other = (BinaryOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Expression this$lhs = this.getLhs();
        Expression other$lhs = other.getLhs();
        if (this$lhs == null ? other$lhs != null : !this$lhs.equals(other$lhs)) {
            return false;
        }
        Token this$operator = this.getOperator();
        Token other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !((Object)this$operator).equals(other$operator)) {
            return false;
        }
        Expression this$rhs = this.getRhs();
        Expression other$rhs = other.getRhs();
        return !(this$rhs == null ? other$rhs != null : !this$rhs.equals(other$rhs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BinaryOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Expression $lhs = this.getLhs();
        result = result * 59 + ($lhs == null ? 43 : $lhs.hashCode());
        Token $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : ((Object)$operator).hashCode());
        Expression $rhs = this.getRhs();
        result = result * 59 + ($rhs == null ? 43 : $rhs.hashCode());
        return result;
    }

    @Generated
    public Expression getLhs() {
        return this.lhs;
    }

    @Generated
    public Token getOperator() {
        return this.operator;
    }

    @Generated
    public Expression getRhs() {
        return this.rhs;
    }
}

