/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.rl.ast;

import java.util.Optional;
import java.util.function.BiConsumer;
import lombok.Generated;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ExpressionVisitor;

abstract class BaseExpr
implements Expression {
    BaseExpr() {
    }

    static <T> void join(StringBuilder appendTo, Iterable<T> items, BiConsumer<StringBuilder, T> callback, String separator, String open, String close) {
        appendTo.append(open);
        boolean first = true;
        for (T item : items) {
            if (!first) {
                appendTo.append(separator);
            }
            callback.accept(appendTo, (StringBuilder)item);
            first = false;
        }
        appendTo.append(close);
    }

    static BaseExpr wrap(Expression expr) {
        if (expr instanceof BaseExpr) {
            return (BaseExpr)expr;
        }
        return new ExprWrapper(expr);
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append("[");
        this.appendSource(builder);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public final String toSource() {
        StringBuilder appendTo = new StringBuilder();
        this.appendSource(appendTo);
        return appendTo.toString();
    }

    protected abstract void appendSource(StringBuilder var1);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    private static class ExprWrapper
    extends BaseExpr {
        private final Expression wrapped;

        @Override
        public Optional<Pair<Token, Token>> getBoundary() {
            return this.wrapped.getBoundary();
        }

        @Override
        public <T, R> R accept(ExpressionVisitor<T, R> visitor, T data) {
            return this.wrapped.accept(visitor, data);
        }

        @Override
        public int hashCode() {
            return this.wrapped.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return this.wrapped.equals(obj);
        }

        @Override
        protected void appendSource(StringBuilder appendTo) {
            appendTo.append(this.wrapped.toSource());
        }

        @Override
        public <T extends Expression> Optional<T> isA(Class<T> type) {
            return this.wrapped.isA(type);
        }

        @Generated
        public ExprWrapper(Expression wrapped) {
            this.wrapped = wrapped;
        }
    }
}

