/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.rl;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import nz.org.riskscape.dsl.Lexer;
import nz.org.riskscape.dsl.LexerException;
import nz.org.riskscape.dsl.LexingMatcher;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.dsl.TokenMatcher;
import nz.org.riskscape.dsl.TokenType;

public enum TokenTypes implements TokenType
{
    KEYWORD_OR(LexingMatcher.forKeyword("or")),
    KEYWORD_AND(LexingMatcher.forKeyword("and")),
    KEYWORD_TRUE(LexingMatcher.forKeyword("true")),
    KEYWORD_FALSE(LexingMatcher.forKeyword("false")),
    KEYWORD_NULL(LexingMatcher.forKeyword("null")),
    KEYWORD_AS(LexingMatcher.forKeyword("as")),
    PARAMETER_IDENTIFIER(LexingMatcher.forPattern("^\\$([a-zA-Z]+[a-zA-Z_0-9]*)")),
    KEY_IDENTIFIER(LexingMatcher.forPattern("^[a-zA-Z]+[a-zA-Z_\\-0-9]*(?= *\\:)")),
    IDENTIFIER(LexingMatcher.forPattern("^[a-zA-Z]+[a-zA-Z_0-9]*")),
    QUOTED_IDENTIFIER(LexingMatcher.forQuotedString('\"')),
    STRING(LexingMatcher.forQuotedString('\'')),
    SCIENTIFIC_NOTATION(LexingMatcher.forPattern("^-?[0-9]+(?:\\.[0-9]+)?[Ee][-+]?[0-9]+")),
    DECIMAL(LexingMatcher.forPattern("^-?[0-9]*\\.[0-9]+")),
    INTEGER(LexingMatcher.forPattern("^-?[0-9]+")),
    INDEX('.'),
    LPAREN('('),
    RPAREN(')'),
    LBRACK('['),
    RBRACK(']'),
    LBRACE('{'),
    RBRACE('}'),
    COMMA(','),
    DOUBLE_COLON("::"),
    COLON(':'),
    CHAIN("->"),
    WHITESPACE(LexingMatcher.forWhitespace(" \t\r\n"), true),
    NOT_EQUALS(LexingMatcher.forPattern("^(<>|!=)")),
    COMMENT_INLINE(LexingMatcher.forPattern("(?s)^\\/\\*.*?\\*\\/"), true),
    EQUALS('='),
    PLUS('+'),
    MINUS('-'),
    POW("**"),
    MULTIPLY('*'),
    DIVIDE('/'),
    OR("||"),
    AND("&&"),
    LESS_THAN_EQUAL("<="),
    GREATER_THAN_EQUAL(">="),
    LESS_THAN('<'),
    GREATER_THAN('>'),
    COMMENT(LexingMatcher.forLineComment("#"), true),
    EOF(LexingMatcher.forPattern("^$"));

    public static final Set<String> KEYWORDS;
    public static final Pattern IDENTIFIER_PATTERN;
    LexingMatcher matcher;
    boolean whitespace;

    public static Lexer.Tokens<TokenTypes> tokens() {
        return new Lexer.Tokens<TokenTypes>(TokenTypes.class, EOF, List.of());
    }

    static TokenMatcher forKeyword(final String keyword) {
        final TokenMatcher patternMatcher = TokenMatcher.forPattern("^(?i)" + keyword + "(?![a-zA-Z_0-9])");
        return new TokenMatcher(){

            @Override
            public Token match(TokenType type, String source, int position) {
                return patternMatcher.match(type, source, position);
            }

            @Override
            public Optional<String> getKeyword() {
                return Optional.of(keyword);
            }
        };
    }

    public static String quoteText(String text) {
        if (text.contains("'")) {
            text = text.replace("'", "\\'");
        }
        return "'" + text + "'";
    }

    public static String quoteTextIfNeeded(String text) {
        if (text.startsWith("'") && text.endsWith("'")) {
            return text;
        }
        return TokenTypes.quoteText(text);
    }

    public static String quoteIdent(String token) {
        Matcher matched = IDENTIFIER_PATTERN.matcher(token);
        if (!matched.matches() || KEYWORDS.contains(token.toLowerCase())) {
            return "\"" + token.replace("\"", "\\\"") + "\"";
        }
        return token;
    }

    public static String stripQuotes(String id) {
        Optional<String> unquoted;
        Lexer<TokenTypes> lexer = new Lexer<TokenTypes>(TokenTypes.tokens(), id);
        try {
            unquoted = lexer.consumeIf(Sets.newHashSet((Object[])new TokenTypes[]{STRING, QUOTED_IDENTIFIER})).map(Token::getValue);
        }
        catch (LexerException e) {
            return id;
        }
        if (lexer.isEOF() && unquoted.isPresent()) {
            return unquoted.get();
        }
        return id;
    }

    public static Token identToken(String identifier) {
        String quoted = TokenTypes.quoteIdent(identifier);
        if (quoted.equals(identifier)) {
            return Token.token(IDENTIFIER, identifier);
        }
        return new Token(QUOTED_IDENTIFIER, quoted, 0, quoted.length(), identifier);
    }

    private TokenTypes(LexingMatcher matcher, boolean whitespace) {
        this.matcher = matcher;
        this.whitespace = whitespace;
    }

    private TokenTypes(LexingMatcher matcher) {
        this.matcher = matcher;
        this.whitespace = false;
    }

    private TokenTypes(char character) {
        this(LexingMatcher.forChar(character));
    }

    private TokenTypes(String string2) {
        this(LexingMatcher.forString(string2));
    }

    @Override
    public LexingMatcher matcher() {
        return this.matcher;
    }

    @Override
    public boolean isWhitespace() {
        return this.whitespace;
    }

    static {
        KEYWORDS = Arrays.stream(TokenTypes.values()).map(tt -> tt.matcher().getKeyword()).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        IDENTIFIER_PATTERN = Pattern.compile("^[a-zA-Z]+[a-zA-Z_0-9]*");
    }
}

