/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.rl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import nz.org.riskscape.dsl.ConditionalParse;
import nz.org.riskscape.dsl.Lexer;
import nz.org.riskscape.dsl.LexerException;
import nz.org.riskscape.dsl.ParseException;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.dsl.UnexpectedTokenException;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.MalformedExpressionException;
import nz.org.riskscape.rl.TokenTypes;
import nz.org.riskscape.rl.ast.BinaryOperation;
import nz.org.riskscape.rl.ast.BracketedExpression;
import nz.org.riskscape.rl.ast.Constant;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ExpressionProblems;
import nz.org.riskscape.rl.ast.FunctionCall;
import nz.org.riskscape.rl.ast.Lambda;
import nz.org.riskscape.rl.ast.ListDeclaration;
import nz.org.riskscape.rl.ast.MinimalVisitor;
import nz.org.riskscape.rl.ast.ParameterToken;
import nz.org.riskscape.rl.ast.PropertyAccess;
import nz.org.riskscape.rl.ast.SelectAllExpression;
import nz.org.riskscape.rl.ast.StructDeclaration;

public class ExpressionParser {
    public static final ExpressionParser INSTANCE = new ExpressionParser();
    public static final EnumSet<TokenTypes> IDENTIFIERS = EnumSet.of(TokenTypes.IDENTIFIER, TokenTypes.QUOTED_IDENTIFIER);
    public static final EnumSet<TokenTypes> KEY_IDENTIFIERS = EnumSet.of(TokenTypes.KEY_IDENTIFIER, TokenTypes.IDENTIFIER, TokenTypes.QUOTED_IDENTIFIER);
    public static final EnumSet<TokenTypes> LITERALS = EnumSet.of(TokenTypes.STRING, new TokenTypes[]{TokenTypes.INTEGER, TokenTypes.DECIMAL, TokenTypes.SCIENTIFIC_NOTATION, TokenTypes.KEYWORD_FALSE, TokenTypes.KEYWORD_TRUE, TokenTypes.KEYWORD_NULL});
    public static final EnumSet<TokenTypes> LEADING_TOKENS = EnumSet.copyOf(ImmutableSet.builder().addAll(IDENTIFIERS).addAll(LITERALS).add((Object)TokenTypes.LBRACE).add((Object)TokenTypes.LBRACK).add((Object)TokenTypes.MULTIPLY).build());
    Set<TokenTypes> binaryOperators = Sets.newHashSet((Object[])new TokenTypes[]{TokenTypes.PLUS, TokenTypes.MINUS, TokenTypes.MULTIPLY, TokenTypes.DIVIDE, TokenTypes.POW, TokenTypes.KEYWORD_OR, TokenTypes.OR, TokenTypes.KEYWORD_AND, TokenTypes.AND, TokenTypes.LESS_THAN, TokenTypes.GREATER_THAN, TokenTypes.LESS_THAN_EQUAL, TokenTypes.GREATER_THAN_EQUAL, TokenTypes.EQUALS, TokenTypes.NOT_EQUALS});

    public static Expression parseString(String source) {
        return INSTANCE.parse(source);
    }

    public Expression parse(String source) {
        return this.parse(source, false);
    }

    public ResultOrProblems<Expression> parseOr(String source) {
        try {
            return ResultOrProblems.of(this.parse(source));
        }
        catch (LexerException | ParseException ex) {
            return ResultOrProblems.failed(Problems.caught(ex));
        }
    }

    public Expression parseAllowParameters(String source) {
        return this.parse(source, true);
    }

    private Expression parse(String source, boolean allowTokens) {
        Expression parsed;
        Lexer<TokenTypes> lexer = this.lex(source);
        if (lexer.peekType() == TokenTypes.EOF) {
            throw new UnexpectedTokenException(ExpressionProblems.get().emptyStringNotValid(), LEADING_TOKENS, lexer.expect(TokenTypes.EOF));
        }
        try {
            parsed = this.parseExpression(lexer);
            lexer.expect(TokenTypes.EOF);
        }
        catch (UnexpectedTokenException ex) {
            throw new MalformedExpressionException(source, ex);
        }
        if (!allowTokens) {
            this.checkForParameters(parsed);
        }
        return parsed;
    }

    public void checkForParameters(Expression parsed) {
        parsed.accept(new MinimalVisitor<Object>(){

            @Override
            public Object visit(ParameterToken parameterToken, Object data) {
                throw new UnexpectedTokenException(ExpressionProblems.get().parametersNotAllowed(parameterToken), LEADING_TOKENS, parameterToken.getToken());
            }
        }, null);
    }

    public StructDeclaration toStruct(Expression expr) {
        return expr.isA(StructDeclaration.class).orElseGet(() -> new StructDeclaration(Arrays.asList(StructDeclaration.anonMember(expr)), Optional.empty()));
    }

    public ListDeclaration toList(Expression expr) {
        return expr.isA(ListDeclaration.class).orElseGet(() -> new ListDeclaration(Arrays.asList(expr), Optional.empty()));
    }

    protected Lexer<TokenTypes> lex(String source) {
        return new Lexer<TokenTypes>(TokenTypes.tokens(), source);
    }

    public Expression parseExpression(Lexer<TokenTypes> lexer) {
        Expression start = (Expression)lexer.tryThese(ConditionalParse.parseIfIs("lambda-noarg", Arrays.asList(TokenTypes.LPAREN, TokenTypes.RPAREN, TokenTypes.CHAIN), () -> this.parseLambdaExpression(lexer)), ConditionalParse.parseIf("lambda-unary", Arrays.asList(Collections.singleton(TokenTypes.LPAREN), IDENTIFIERS, Collections.singleton(TokenTypes.RPAREN), EnumSet.of(TokenTypes.CHAIN)), () -> this.parseLambdaExpression(lexer)), ConditionalParse.parseIf("lambda-unary-bracketed", Arrays.asList(IDENTIFIERS, EnumSet.of(TokenTypes.CHAIN)), () -> this.parseLambdaExpression(lexer)), ConditionalParse.parseIf("lambda", Arrays.asList(Collections.singleton(TokenTypes.LPAREN), IDENTIFIERS, Collections.singleton(TokenTypes.COMMA)), () -> this.parseLambdaExpression(lexer)), ConditionalParse.parseIf("empty-struct", Arrays.asList(EnumSet.of(TokenTypes.LBRACE), EnumSet.of(TokenTypes.RBRACE)), () -> this.parseStructExpression(lexer)), ConditionalParse.parseIf("struct-expression", Arrays.asList(EnumSet.of(TokenTypes.LBRACE), KEY_IDENTIFIERS, EnumSet.of(TokenTypes.COLON)), () -> this.parseStructExpression(lexer)), ConditionalParse.parseIf("struct-expression-leading-select-all", Arrays.asList(EnumSet.of(TokenTypes.LBRACE), EnumSet.of(TokenTypes.MULTIPLY), EnumSet.of(TokenTypes.COMMA), KEY_IDENTIFIERS, EnumSet.of(TokenTypes.COLON)), () -> this.parseStructExpression(lexer)), ConditionalParse.parseIfIs("struct-expression-as-syntax", TokenTypes.LBRACE, () -> this.parseStructExpressionAsSyntax(lexer)), ConditionalParse.parseIfIs("list-expression", TokenTypes.LBRACK, () -> this.parseListExpression(lexer)), ConditionalParse.parseIfOneOf("constant-expression", LITERALS, () -> this.parseConstantExpression(lexer)), ConditionalParse.parseIfIs("brackets-expression", TokenTypes.LPAREN, () -> this.parseBracketedExpression(lexer)), ConditionalParse.parseIf("function-expression", Arrays.asList(KEY_IDENTIFIERS, EnumSet.of(TokenTypes.LPAREN)), () -> this.parseFunctionExpression(lexer)), ConditionalParse.parseIfOneOf("property-expression", IDENTIFIERS, () -> this.parsePropertyExpression(lexer, Optional.empty())), ConditionalParse.parseIfIs("select-all", TokenTypes.MULTIPLY, () -> this.parseSplatExpression(lexer)), ConditionalParse.parseIfIs("token", TokenTypes.PARAMETER_IDENTIFIER, () -> this.parseParameterExpression(lexer)));
        if (this.binaryOperators.contains(lexer.peekType())) {
            return this.parseBinaryExpression(lexer, start);
        }
        if (lexer.peekType() == TokenTypes.INDEX) {
            lexer.next();
            if (lexer.peekType() == TokenTypes.MULTIPLY) {
                return new PropertyAccess(Optional.of(start), Collections.singletonList(lexer.next()));
            }
            return this.parsePropertyExpression(lexer, Optional.of(start));
        }
        return start;
    }

    private Expression parseParameterExpression(Lexer<TokenTypes> lexer) {
        return new ParameterToken(lexer.next());
    }

    private SelectAllExpression parseSplatExpression(Lexer<TokenTypes> lexer) {
        return new SelectAllExpression(lexer.expect(TokenTypes.MULTIPLY));
    }

    private Expression parseLambdaExpression(Lexer<TokenTypes> lexer) {
        List<Token> args;
        Token left;
        if (lexer.peekType() == TokenTypes.LPAREN) {
            left = lexer.next();
            if (lexer.consumeIf(TokenTypes.RPAREN).isPresent()) {
                args = Collections.emptyList();
            } else {
                Token commaOrParen;
                args = new LinkedList<Token>();
                do {
                    Token ident = lexer.expect(IDENTIFIERS);
                    args.add(ident);
                    commaOrParen = lexer.expect(TokenTypes.COMMA, TokenTypes.RPAREN);
                } while (commaOrParen.type != TokenTypes.RPAREN);
            }
        } else {
            left = lexer.expect(IDENTIFIERS);
            args = Collections.singletonList(left);
        }
        lexer.expect(TokenTypes.CHAIN);
        Expression expr = this.parseExpression(lexer);
        return new Lambda(left, args, expr);
    }

    private Expression parseStructExpression(Lexer<TokenTypes> lexer) {
        Token opening = lexer.expect(TokenTypes.LBRACE);
        boolean selectAllSeen = false;
        ArrayList<StructDeclaration.Member> members = new ArrayList<StructDeclaration.Member>();
        while (lexer.peekType() != TokenTypes.RBRACE) {
            if (lexer.peekType().equals(TokenTypes.MULTIPLY)) {
                Token selectAll = lexer.next();
                if (selectAllSeen) {
                    throw new UnexpectedTokenException(ExpressionProblems.get().duplicateSelectAll(selectAll), KEY_IDENTIFIERS, selectAll);
                }
                selectAllSeen = true;
                members.add(StructDeclaration.selectAllMember(selectAll));
            } else {
                Token ident = lexer.expect(KEY_IDENTIFIERS);
                lexer.expect(TokenTypes.COLON);
                members.add(StructDeclaration.jsonStyleMember(ident, this.parseExpression(lexer)));
            }
            if (lexer.peekType() == TokenTypes.RBRACE) continue;
            lexer.expect(TokenTypes.COMMA);
        }
        return new StructDeclaration(members, Optional.of(Pair.of(opening, lexer.expect(TokenTypes.RBRACE))));
    }

    private Expression parseStructExpressionAsSyntax(Lexer<TokenTypes> lexer) {
        Token opening = lexer.expect(TokenTypes.LBRACE);
        ArrayList<StructDeclaration.Member> members = new ArrayList<StructDeclaration.Member>();
        boolean selectAllSeen = false;
        while (lexer.peekType() != TokenTypes.RBRACE) {
            if (lexer.peekType() == TokenTypes.MULTIPLY) {
                Token selectAll = lexer.next();
                if (selectAllSeen) {
                    throw new UnexpectedTokenException(ExpressionProblems.get().duplicateSelectAll(selectAll), LEADING_TOKENS, selectAll);
                }
                selectAllSeen = true;
                members.add(StructDeclaration.selectAllMember(selectAll));
            } else {
                Expression expr = this.parseExpression(lexer);
                Optional<Token> asToken = lexer.consumeIf(TokenTypes.KEYWORD_AS);
                if (asToken.isPresent()) {
                    Token ident = lexer.expect(TokenTypes.IDENTIFIER, TokenTypes.QUOTED_IDENTIFIER);
                    members.add(StructDeclaration.sqlStyleMember(ident, expr, asToken.get()));
                } else {
                    members.add(StructDeclaration.anonMember(expr));
                }
            }
            if (lexer.peekType() == TokenTypes.RBRACE) continue;
            lexer.expect(TokenTypes.COMMA);
        }
        return new StructDeclaration(members, Optional.of(Pair.of(opening, lexer.expect(TokenTypes.RBRACE))));
    }

    private Expression parseListExpression(Lexer<TokenTypes> lexer) {
        Token opening = lexer.expect(TokenTypes.LBRACK);
        ArrayList<Expression> listDeclaration = new ArrayList<Expression>();
        while (lexer.peekType() != TokenTypes.RBRACK) {
            listDeclaration.add(this.parseExpression(lexer));
            if (lexer.peekType() == TokenTypes.RBRACK) continue;
            lexer.expect(TokenTypes.COMMA);
        }
        return new ListDeclaration(listDeclaration, Optional.of(Pair.of(opening, lexer.expect(TokenTypes.RBRACK))));
    }

    private Expression parseBracketedExpression(Lexer<TokenTypes> lexer) {
        Token opening = lexer.expect(TokenTypes.LPAREN);
        Expression expression = this.parseExpression(lexer);
        return new BracketedExpression(expression, Optional.of(Pair.of(opening, lexer.expect(TokenTypes.RPAREN))));
    }

    public FunctionCall parseFunctionExpression(Lexer<TokenTypes> lexer) {
        Token separator;
        Token identifier = lexer.expect(TokenTypes.IDENTIFIER, TokenTypes.QUOTED_IDENTIFIER);
        lexer.expect(TokenTypes.LPAREN);
        if (lexer.peekType() == TokenTypes.RPAREN) {
            return new FunctionCall(identifier, Collections.emptyList(), lexer.next());
        }
        ArrayList args = Lists.newArrayList();
        do {
            Token keywordIdentifier;
            if ((keywordIdentifier = (Token)lexer.consumeIf(KEY_IDENTIFIERS).orElse(null)) != null) {
                if (lexer.peekType() == TokenTypes.COLON) {
                    lexer.next();
                } else {
                    lexer.rewind(keywordIdentifier);
                    keywordIdentifier = null;
                }
            }
            Expression arg = this.parseExpression(lexer);
            args.add(new FunctionCall.Argument(arg, Optional.ofNullable(keywordIdentifier)));
            separator = lexer.expect(TokenTypes.COMMA, TokenTypes.RPAREN);
        } while (separator.type != TokenTypes.RPAREN);
        lexer.rewind(separator);
        return new FunctionCall(identifier, (List<FunctionCall.Argument>)args, lexer.expect(TokenTypes.RPAREN));
    }

    private Constant parseConstantExpression(Lexer<TokenTypes> lexer) {
        return new Constant(lexer.expect(LITERALS));
    }

    public PropertyAccess parsePropertyExpression(Lexer<TokenTypes> lexer, Optional<Expression> receiver) {
        ArrayList identifiers = Lists.newArrayList();
        identifiers.add(lexer.expect(TokenTypes.IDENTIFIER, TokenTypes.QUOTED_IDENTIFIER));
        while (lexer.peekType() == TokenTypes.INDEX) {
            lexer.next();
            if (lexer.peekType().equals(TokenTypes.MULTIPLY)) {
                identifiers.add(lexer.next());
                break;
            }
            identifiers.add(lexer.expect(TokenTypes.IDENTIFIER, TokenTypes.QUOTED_IDENTIFIER));
        }
        return new PropertyAccess(receiver, identifiers);
    }

    private BinaryOperation parseBinaryExpression(Lexer<TokenTypes> lexer, Expression lhs) {
        Token operation = lexer.expect(this.binaryOperators.toArray(new TokenTypes[0]));
        return new BinaryOperation(lhs, operation, this.parseExpression(lexer));
    }
}

