/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.problem;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.Unchecked;
import nz.org.riskscape.engine.types.Anything;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultComputationException;
import nz.org.riskscape.util.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResultOrProblems<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResultOrProblems.class);
    public static final List<Problem> NO_PROBLEMS = Collections.emptyList();
    private final T computedResult;
    private final Problems problems;

    public static <T> ResultOrProblems<T> of(@NonNull T thing) {
        if (thing == null) {
            throw new NullPointerException("thing is marked non-null but is null");
        }
        return new ResultOrProblems<T>(thing, NO_PROBLEMS);
    }

    public static <T> ResultOrProblems<T> of(@NonNull T thing, Problem ... problems) {
        if (thing == null) {
            throw new NullPointerException("thing is marked non-null but is null");
        }
        return new ResultOrProblems<T>(thing, problems.length == 0 ? NO_PROBLEMS : Arrays.asList(problems));
    }

    public static <T> ResultOrProblems<T> of(@NonNull T thing, List<Problem> withProblems) {
        if (thing == null) {
            throw new NullPointerException("thing is marked non-null but is null");
        }
        return new ResultOrProblems<T>(thing, withProblems.size() == 0 ? NO_PROBLEMS : withProblems);
    }

    public static <T> ResultOrProblems<T> ofNullable(T thing, List<Problem> withProblems) {
        return new ResultOrProblems<T>(thing, withProblems);
    }

    public static <T> ResultOrProblems<T> failed(Collection<ResultOrProblems<?>> failures) {
        if (failures.size() == 0) {
            throw new IllegalArgumentException("at least one failure must be given");
        }
        ArrayList<Problem> collectedProblems = new ArrayList<Problem>(failures.size() * 2);
        for (ResultOrProblems<?> failure : failures) {
            collectedProblems.addAll(failure.getProblems());
        }
        if (Problem.hasErrors(collectedProblems)) {
            return ResultOrProblems.failed(collectedProblems);
        }
        throw new IllegalArgumentException("A failed result can not be constructed without error level problems");
    }

    public static <T> ResultOrProblems<T> failed(ResultOrProblems<?> firstFailure, ResultOrProblems<?> ... restFailures) throws IllegalArgumentException {
        return ResultOrProblems.failed(ListUtils.prepend(firstFailure, restFailures));
    }

    public static <T> ResultOrProblems<T> failed(Problem ... withProblems) {
        return ResultOrProblems.failed(Arrays.asList(withProblems));
    }

    public static <T> ResultOrProblems<T> failed(List<Problem> withProblems) {
        return new ResultOrProblems<Object>(null, withProblems.size() == 0 ? NO_PROBLEMS : withProblems);
    }

    public static <T> ResultOrProblems<T> error(String msg) {
        return ResultOrProblems.error("%s", msg);
    }

    public static <T> ResultOrProblems<T> error(String msg, Object ... args) {
        return ResultOrProblems.failed(Problem.error(msg, args));
    }

    public static <T> ResultOrProblems<T> error(RiskscapeException ex) {
        return ResultOrProblems.failed(Problems.caught(ex));
    }

    public static ResultOrProblems<Anything> unchecked(String message) {
        return new ResultOrProblems<Anything>(Types.ANYTHING, Arrays.asList(new Unchecked(message)));
    }

    public ResultOrProblems(T computedResult, List<Problem> problems) {
        this.computedResult = computedResult;
        this.problems = Problems.from(problems);
        int idx = 0;
        for (Problem problem : problems) {
            if (problem == null) {
                throw new NullPointerException("Problem " + idx + " is null");
            }
            ++idx;
        }
    }

    public List<Problem> getProblems() {
        return this.problems.toList();
    }

    private void logIfWarningsIgnored() {
        if (this.problems.isPresent()) {
            Throwable t = new Throwable("");
            t.fillInStackTrace();
            log.warn("Non-error problems are present and have not been consumed - warnings are being hidden - ", t);
            assert (false) : "Warnings are being hidden";
        }
    }

    public T get() {
        if (this.computedResult == null || this.hasErrors()) {
            throw new ResultComputationException(this.getProblems());
        }
        this.logIfWarningsIgnored();
        return this.computedResult;
    }

    public T getOrThrow() throws ProblemException {
        if (this.computedResult == null || this.hasErrors()) {
            throw new ProblemException(this.problems);
        }
        this.logIfWarningsIgnored();
        return this.computedResult;
    }

    public T getOrThrow(Problem parent) throws ProblemException {
        if (this.computedResult == null || this.hasErrors()) {
            throw new ProblemException((Problems)parent.withChildren(this.problems));
        }
        this.logIfWarningsIgnored();
        return this.computedResult;
    }

    public T getOrThrow(Function<Problems, Problems> problemFunction) throws ProblemException {
        if (this.computedResult == null || this.hasErrors()) {
            throw new ProblemException(problemFunction.apply(this.problems));
        }
        this.logIfWarningsIgnored();
        return this.computedResult;
    }

    public T getWithProblemsIgnored() {
        return this.computedResult;
    }

    public ResultOrProblems<T> drainWarnings(Consumer<Problem> problemConsumer) {
        if (this.problems.isEmpty() || this.computedResult == null) {
            return this;
        }
        if (this.problems.stream().allMatch(p -> p.severity.ordinal() <= Problem.Severity.WARNING.ordinal())) {
            this.problems.forEach(problemConsumer);
            return ResultOrProblems.of(this.computedResult);
        }
        return this;
    }

    public ResultOrProblems<T> drainWarnings(Consumer<Problem> problemConsumer, BiFunction<Problem.Severity, List<Problem>, Problem> callback) {
        if (this.problems.isEmpty() || this.computedResult == null) {
            return this;
        }
        if (this.problems.stream().allMatch(p -> p.severity.ordinal() <= Problem.Severity.WARNING.ordinal())) {
            Problem.Severity max = this.problems.getSeverity();
            problemConsumer.accept(callback.apply(max, this.problems.toList()));
            return ResultOrProblems.of(this.computedResult);
        }
        return this;
    }

    public <U> Optional<U> ifProblems(Function<List<Problem>, U> function) {
        if (this.problems.isPresent()) {
            return Optional.ofNullable(function.apply(this.problems.toList()));
        }
        return Optional.empty();
    }

    public boolean isPresent() {
        return this.computedResult != null;
    }

    public void ifPresent(Consumer<T> function) {
        if (this.computedResult != null) {
            function.accept(this.computedResult);
        }
    }

    public void ifElse(Consumer<T> function, Consumer<List<Problem>> elseConsume) {
        if (this.computedResult != null) {
            function.accept(this.computedResult);
        } else {
            elseConsume.accept(this.problems.toList());
        }
    }

    public <U> U ifElseReturn(Function<T, U> function, Function<List<Problem>, U> elseConsume) {
        if (this.computedResult != null) {
            return function.apply(this.computedResult);
        }
        return elseConsume.apply(this.problems.toList());
    }

    public <U> U ifElseReturn(Function<T, U> function, Consumer<List<Problem>> elseConsume, U elseReturn) {
        if (this.computedResult != null) {
            return function.apply(this.computedResult);
        }
        elseConsume.accept(this.problems.toList());
        return elseReturn;
    }

    public boolean hasProblems() {
        return this.problems.isPresent();
    }

    public boolean hasProblems(Problem.Severity greaterThanEqualTo) {
        for (Problem problem : this.problems) {
            if (problem.getSeverity().ordinal() < greaterThanEqualTo.ordinal()) continue;
            return true;
        }
        return false;
    }

    public List<Problem> filterProblems(Class<?> affects) {
        return Problem.filterAffected(this.problems.toList(), affects);
    }

    public <U> ResultOrProblems<U> flatMap(Function<? super T, ResultOrProblems<U>> mapper) {
        return this.flatMap((T t, List<Problem> p) -> {
            ResultOrProblems mapped = (ResultOrProblems)mapper.apply(t);
            return ResultOrProblems.ofNullable(mapped.computedResult, ListUtils.concat(this.problems.toList(), mapped.problems.toList()));
        });
    }

    public <U> ResultOrProblems<U> flatMap(BiFunction<T, List<Problem>, ResultOrProblems<U>> mapper) {
        ResultOrProblems<U> mapped = null;
        if (this.computedResult == null) {
            return this;
        }
        mapped = mapper.apply(this.computedResult, this.problems.toList());
        return mapped;
    }

    public <U> ResultOrProblems<U> map(Function<T, U> mapper) {
        T mapped = null;
        if (this.computedResult != null && (mapped = (T)mapper.apply(this.computedResult)) == null) {
            throw new NullPointerException("mapper must return a result, or use flatMap");
        }
        return new ResultOrProblems<Object>(mapped, this.problems.toList());
    }

    public <U> ResultOrProblems<U> map(Function<T, U> mapper, Function<Problem, Problem> problemMapper) {
        T mapped = null;
        if (this.computedResult != null && (mapped = (T)mapper.apply(this.computedResult)) == null) {
            throw new NullPointerException("mapper must return a result, or use flatMap");
        }
        return new ResultOrProblems<Object>(mapped, this.problems.stream().map(problemMapper).collect(Collectors.toList()));
    }

    public <U> ResultOrProblems<U> mapOrCombine(Function<T, U> mapper, ResultOrProblems<?> ... dependencies) {
        List<ResultOrProblems<?>> all = ListUtils.prepend(this, dependencies);
        for (ResultOrProblems<?> dependency : all) {
            if (!dependency.hasErrors()) continue;
            return ResultOrProblems.failed(all);
        }
        return this.map(mapper);
    }

    public T orElse(T otherThing) {
        if (this.computedResult == null) {
            return otherThing;
        }
        return this.computedResult;
    }

    public T orElse(Consumer<List<Problem>> consumeProblems, T elseReturn) {
        if (this.computedResult == null) {
            consumeProblems.accept(this.problems.toList());
            return elseReturn;
        }
        this.logIfWarningsIgnored();
        return this.computedResult;
    }

    public T orElseGet(Function<List<Problem>, T> resultFunction) {
        if (this.computedResult == null) {
            return resultFunction.apply(this.problems.toList());
        }
        this.logIfWarningsIgnored();
        return this.computedResult;
    }

    public ResultOrProblems<T> withMoreProblems(Problem ... moreProblems) {
        return this.withMoreProblems(Arrays.asList(moreProblems));
    }

    public ResultOrProblems<T> withMoreProblems(Function<T, List<Problem>> validation) {
        if (this.computedResult == null) {
            return this;
        }
        return this.withMoreProblems((Collection<Problem>)validation.apply(this.computedResult));
    }

    public ResultOrProblems<T> withMoreProblems(Collection<Problem> moreProblems) {
        ArrayList newProblems = Lists.newArrayList();
        newProblems.addAll(this.problems.toList());
        newProblems.addAll(moreProblems);
        return new ResultOrProblems<T>(this.computedResult, newProblems);
    }

    public <X extends Throwable> T orElseThrow(Function<List<Problem>, ? extends X> exceptionSupplier) throws X {
        if (this.computedResult != null) {
            return this.computedResult;
        }
        throw (Throwable)exceptionSupplier.apply(this.problems.toList());
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.computedResult != null) {
            this.logIfWarningsIgnored();
            return this.computedResult;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public String toString() {
        if (this.computedResult != null) {
            if (this.problems.isEmpty()) {
                return String.format("Of(%s)", this.computedResult);
            }
            return String.format("Of(%s, %d problems)", this.computedResult, this.problems.toList().size());
        }
        return String.format("Failed(%s)", this.problems);
    }

    public boolean hasErrors() {
        return this.hasProblems(Problem.Severity.ERROR);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ResultOrProblems)) {
            return false;
        }
        ResultOrProblems rhs = (ResultOrProblems)obj;
        return Objects.equals(this.computedResult, rhs.computedResult) && Objects.equals(this.problems, rhs.problems);
    }

    public int hashCode() {
        return Objects.hash(this.computedResult, this.problems);
    }

    @Deprecated
    public ResultOrProblems<T> composeProblems(String message, Object ... args) {
        if (this.hasProblems()) {
            return ResultOrProblems.ofNullable(this.computedResult, Collections.singletonList(Problem.composite(this.problems.toList(), message, args)));
        }
        return this;
    }

    public ResultOrProblems<T> composeProblems(Problem parentProblem) {
        if (this.hasProblems()) {
            Problem.Severity severity = this.problems.getSeverity();
            return ResultOrProblems.ofNullable(this.computedResult, Collections.singletonList(parentProblem.withChildren(this.problems).withSeverity(severity)));
        }
        return this;
    }

    public ResultOrProblems<T> composeProblems(BiFunction<Problem.Severity, List<Problem>, Problem> callback) {
        if (this.hasProblems()) {
            Problem.Severity severity = this.problems.getSeverity();
            return ResultOrProblems.ofNullable(this.computedResult, Collections.singletonList(callback.apply(severity, this.getProblems())));
        }
        return this;
    }

    public <U> ResultOrProblems<U> composeFailure(Problem parentProblem) {
        Problem.Severity severity = this.problems.getSeverity();
        return ResultOrProblems.failed(parentProblem.withChildren(this.problems).withSeverity(severity));
    }

    public ResultOrProblems<T> addProblemsTo(Collection<Problem> collection) {
        collection.addAll(this.problems.toList());
        return this;
    }

    public Problem getAsSingleProblem() {
        return this.problems.toProblem().get();
    }
}

