/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.problem;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.problem.ProblemFactoryProxy;
import nz.org.riskscape.engine.problem.ProblemPlaceholder;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemCode;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.ProblemList;
import nz.org.riskscape.problem.StandardCodes;

public interface Problems
extends Iterable<Problem> {
    public static final Problems NONE = ProblemList.of();

    public static Problem errorWith(ProblemCode code, Object thing, Object ... otherArgs) {
        ArrayList args = Lists.newArrayList((Object[])otherArgs);
        args.add(0, thing);
        return Problem.error(code, args.toArray()).affecting(thing);
    }

    public static Problem foundWith(Object thing, Problems children) {
        return Problems.foundWith(thing, children.toList());
    }

    public static Problem foundWith(Object thing, List<Problem> children) {
        Problem problem = new Problem(children, (ProblemCode)StandardCodes.PROBLEMS_FOUND, thing).affecting(thing);
        if (children.isEmpty()) {
            problem = problem.withSeverity(Problem.Severity.ERROR);
        }
        return problem;
    }

    public static Problem foundWith(Object thing, Problem ... child) {
        return Problems.foundWith(thing, Arrays.asList(child));
    }

    public static Problem foundWith(Class<?> thing, String name, List<Problem> children) {
        return Problems.foundWith((Object)ProblemPlaceholder.of(thing, name), children);
    }

    public static Problem foundWith(Class<?> thing, String name, Problem ... child) {
        return Problems.foundWith(thing, name, Arrays.asList(child));
    }

    public static Problem toSingleProblem(List<Problem> children) {
        if (children.size() == 1) {
            return children.get(0);
        }
        return GeneralProblems.get().multipleProblems().withChildren(children).withSeverity(Problem.max(children));
    }

    public static Problem caught(Throwable ex) {
        String message;
        if (ex instanceof RiskscapeException) {
            RiskscapeException rex = (RiskscapeException)ex;
            if (rex.getProblem() != null) {
                return rex.getProblem();
            }
            message = Strings.isNullOrEmpty((String)ex.getMessage()) ? rex.toString() : rex.getMessage();
        } else {
            if (ex instanceof ProblemException) {
                return Problems.toSingleProblem(((ProblemException)ex).getProblems());
            }
            if (ex.getCause() instanceof RiskscapeException) {
                return Problems.caught(ex.getCause());
            }
            message = ex.toString();
        }
        return Problem.error(StandardCodes.CAUGHT_EXCEPTION, message).withException(ex);
    }

    public static Problem parseError(Object expected) {
        return Problem.error(StandardCodes.CANT_PARSE, expected, "").affecting(expected);
    }

    public static <T extends ProblemFactory> T get(Class<T> factory) {
        return (T)((ProblemFactory)Proxy.newProxyInstance(factory.getClassLoader(), new Class[]{factory}, (InvocationHandler)new ProblemFactoryProxy()));
    }

    public static Problems from(List<Problem> children) {
        if (children.size() == 0) {
            return NONE;
        }
        if (children.size() == 1) {
            return children.get(0);
        }
        return ProblemList.copyOf(children);
    }

    public static Problems from(Problem ... children) {
        if (children.length == 0) {
            return NONE;
        }
        if (children.length == 1) {
            return children[0];
        }
        return ProblemList.copyOf(List.of(children));
    }

    public Optional<Problem> toProblem();

    public List<Problem> toList();

    public Stream<Problem> stream();

    default public boolean isPresent() {
        return !this.isEmpty();
    }

    public boolean isEmpty();

    public Problem.Severity getSeverity();
}

