/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.problem;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;

class ProblemList
implements Problems {
    private final List<Problem> list;

    static ProblemList of() {
        return new ProblemList(List.of());
    }

    static ProblemList copyOf(List<Problem> children) {
        assert (children.size() > 1) : "Should not be creating lists from less than 2 problems";
        return new ProblemList(List.copyOf(children));
    }

    private ProblemList(List<Problem> wrapping) {
        this.list = List.copyOf(wrapping);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<Problem> iterator() {
        return this.list.iterator();
    }

    @Override
    public Optional<Problem> toProblem() {
        if (this.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Problems.toSingleProblem(this.list));
    }

    @Override
    public Stream<Problem> stream() {
        return this.list.stream();
    }

    @Override
    public List<Problem> toList() {
        return this.list;
    }

    @Override
    public Problem.Severity getSeverity() {
        return this.list.stream().map(p -> p.severity).max((s1, s2) -> s1.compareTo(s2)).orElse(Problem.Severity.INFO);
    }
}

