/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.problem;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public class ProblemException
extends Exception {
    private final Problems problem;

    public static void throwUnlessEmpty(List<Problem> problems) throws ProblemException {
        if (!problems.isEmpty()) {
            throw new ProblemException(Problems.from(problems));
        }
    }

    public static final <T> ResultOrProblems<T> catching(Call<T> call) {
        try {
            return ResultOrProblems.of(call.call());
        }
        catch (ProblemException e) {
            return e.toResult();
        }
    }

    public static final <T> ResultOrProblems<T> catching(ProblemsCall<T> call) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        try {
            T result = call.call(problems);
            if (Problem.hasErrors(problems)) {
                return ResultOrProblems.failed(problems);
            }
            return ResultOrProblems.of(result, problems);
        }
        catch (ProblemException e) {
            if (problems.isEmpty()) {
                return e.toResult();
            }
            ArrayList<Problem> combined = new ArrayList<Problem>();
            combined.addAll(e.getProblems());
            combined.addAll(problems);
            return ResultOrProblems.failed(combined);
        }
    }

    public ProblemException(Problem ... problems) {
        this(Problems.from(problems));
    }

    public ProblemException(List<Problem> problems) {
        this(Problems.from(problems));
    }

    public <T> ResultOrProblems<T> toResult() {
        return ResultOrProblems.failed(this.problem.toList());
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    public List<Problem> getProblems() {
        return this.problem.toList();
    }

    @Override
    public String getMessage() {
        return this.problem.toProblem().toString();
    }

    @Generated
    public ProblemException(Problems problem) {
        this.problem = problem;
    }

    @FunctionalInterface
    public static interface Call<T> {
        public T call() throws ProblemException;
    }

    @FunctionalInterface
    public static interface ProblemsCall<T> {
        public T call(List<Problem> var1) throws ProblemException;
    }
}

