/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.problem;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import nz.org.riskscape.engine.Identified;
import nz.org.riskscape.engine.OsUtils;
import nz.org.riskscape.engine.problem.ProblemPlaceholder;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.problem.ProblemCode;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.StandardCodes;

public class Problem
implements Problems {
    public final Severity severity;
    private final String defaultMessageFormat;
    private final Object[] arguments;
    private final Throwable exception;
    private final ProblemCode code;
    private final AffectedMetadata affected;
    private final Problems children;

    public static AffectedMetadata wrapAffectedObject(Object thing) {
        if (thing == null) {
            return null;
        }
        if (thing instanceof ProblemPlaceholder) {
            ProblemPlaceholder identified = (ProblemPlaceholder)thing;
            return new AffectedMetadata(null, identified.getWrappedClass(), identified.getId());
        }
        String name = thing instanceof Identified ? ((Identified)thing).getId() : "";
        Class reportedClass = thing instanceof List ? List.class : thing.getClass();
        return new AffectedMetadata(thing, reportedClass, name);
    }

    @Deprecated
    public static Problem info(String message, Object ... args) {
        return new Problem(Severity.INFO, message, args, null);
    }

    @Deprecated
    public static Problem warning(String message, Object ... args) {
        return new Problem(Severity.WARNING, message, args, null);
    }

    @Deprecated
    public static Problem warning(Throwable t, String message, Object ... args) {
        return new Problem(Severity.WARNING, message, args, t);
    }

    @Deprecated
    public static Problem error(String message, Object ... args) {
        return new Problem(Severity.ERROR, message, args, null);
    }

    @Deprecated
    public static Problem error(Throwable t, String message, Object ... args) {
        return new Problem(Severity.ERROR, message, args, t);
    }

    @Deprecated
    public static Problem fatal(Throwable t, String message, Object ... args) {
        return new Problem(Severity.FATAL, message, args, t);
    }

    @Deprecated
    public static Problem composite(List<Problem> children, String message, Object ... args) {
        return Problem.composite(Problem.max(children), children, message, args);
    }

    @Deprecated
    public static Problem composite(Severity severity, List<Problem> children, String message, Object ... args) {
        if (children.isEmpty()) {
            throw new IllegalArgumentException("Can not create a parent problem without children");
        }
        return new Problem(children, severity, message, args);
    }

    @Deprecated
    public Problem(Severity severity, String message) {
        this(severity, "%s", new Object[]{message}, null);
    }

    @Deprecated
    public Problem(Severity severity, String message, Object[] args, Throwable t) {
        this(severity, message, args, t, StandardCodes.NONE, null, Problems.NONE);
    }

    @Deprecated
    public Problem(List<Problem> children, Severity severity, String message, Object[] args) {
        this(severity, message, args, null, StandardCodes.NONE, null, Problems.from(children));
    }

    public static Problem error(ProblemCode code, Object ... args) {
        return new Problem(Severity.ERROR, code, args);
    }

    public Problem(Severity severity, ProblemCode code, Object ... args) {
        this(severity, "", args, null, code, null, Problems.NONE);
    }

    public Problem(List<Problem> children, ProblemCode code, Object ... args) {
        this(Problem.max(children), "", args, null, code, null, Problems.from(children));
    }

    public static Severity max(Collection<? extends Problem> children) {
        return children.stream().map(p -> p.severity).max((s1, s2) -> s1.compareTo(s2)).orElse(Severity.INFO);
    }

    public static boolean hasErrors(Collection<? extends Problem> problems) {
        return Problem.max(problems).ordinal() >= Severity.ERROR.ordinal();
    }

    public static <T extends Throwable> void throwIfErrors(List<Problem> problems, Function<List<Problem>, T> supplier) throws T {
        if (Problem.hasErrors(problems)) {
            throw (Throwable)supplier.apply(problems);
        }
    }

    public Problem withChildren(Problems ... moreChildren) {
        ArrayList<Problem> all = new ArrayList<Problem>();
        for (Problems more : moreChildren) {
            all.addAll(more.toList());
        }
        return this.withChildren(all);
    }

    public Problem withChildren(List<? extends Problem> moreChildren) {
        ArrayList<Problem> combinedProblems = new ArrayList<Problem>(this.children.toList());
        combinedProblems.addAll(moreChildren);
        return new Problem(this.severity, this.defaultMessageFormat, this.arguments, this.exception, this.code, this.affected, Problems.from(combinedProblems));
    }

    public Problem setChildren(List<Problem> newChildren) {
        return new Problem(this.severity, this.defaultMessageFormat, this.arguments, this.exception, this.code, this.affected, Problems.from(newChildren));
    }

    public Problem withSeverity(Severity sev) {
        return new Problem(sev, this.defaultMessageFormat, this.arguments, this.exception, this.code, this.affected, this.children);
    }

    public Problem withException(Throwable t) {
        return new Problem(this.severity, this.defaultMessageFormat, this.arguments, t, this.code, this.affected, this.children);
    }

    public Problem affecting(Class<?> clazz, String name) {
        return this.affecting(new AffectedMetadata(null, clazz, name));
    }

    public Problem affecting(Object thing) {
        return this.affecting(Problem.wrapAffectedObject(thing));
    }

    private Problem affecting(AffectedMetadata affects) {
        return new Problem(this.severity, this.defaultMessageFormat, this.arguments, this.exception, this.code, affects, this.children);
    }

    public boolean isError() {
        return this.severity.ordinal() >= Severity.ERROR.ordinal();
    }

    public boolean isFatal() {
        return this.severity == Severity.FATAL;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public String getMessage() {
        return this.getDefaultMessage();
    }

    public String getDefaultMessage() {
        String message = this.defaultMessageFormat.isEmpty() ? String.format("%s.%s: args=%s", ProblemCode.class.getSimpleName(), this.code.name(), Arrays.toString(this.arguments)) : String.format(this.defaultMessageFormat, this.arguments);
        return message;
    }

    private Optional<AffectedMetadata> getAffected() {
        return Optional.ofNullable(this.affected);
    }

    public String getAffectedName() {
        return this.getAffected().map(AffectedMetadata::getName).orElse("");
    }

    public Optional<Object> getAffectedObject() {
        return this.getAffected().map(c -> Optional.ofNullable(c.getUnderlyingObject())).orElse(Optional.empty());
    }

    public Class<?> getAffectedClass() {
        if (this.getAffected().isPresent()) {
            return this.getAffected().get().getUnderlyingClass();
        }
        return Object.class;
    }

    public boolean affects(Class<?> superclass) {
        return this.getAffected().map(c -> superclass.isAssignableFrom(c.getUnderlyingClass())).orElse(false);
    }

    public <T> Optional<T> getAffected(Class<T> classOfThing) {
        if (this.affects(classOfThing)) {
            return this.getAffectedObject();
        }
        return Optional.empty();
    }

    private static void filterAffected(Collection<? extends Problem> problems, Class<?> contextClass, List<Problem> filteredResult) {
        for (Problem problem : problems) {
            if (problem.affects(contextClass)) {
                filteredResult.add(problem);
            }
            if (!problem.hasChildren()) continue;
            Problem.filterAffected(problem.getChildren(), contextClass, filteredResult);
        }
    }

    public static List<Problem> filterAffected(Collection<? extends Problem> problems, Class<?> contextClass) {
        ArrayList<Problem> filteredResult = new ArrayList<Problem>();
        Problem.filterAffected(problems, contextClass, filteredResult);
        return filteredResult;
    }

    public static String debugString(Problem origin) {
        StringBuilder builder = new StringBuilder();
        LinkedList<Pair<String, Problem>> stack = new LinkedList<Pair<String, Problem>>();
        stack.add(Pair.of("", origin));
        while (!stack.isEmpty()) {
            Pair current = (Pair)stack.removeFirst();
            Problem problem = (Problem)current.getRight();
            builder.append((String)current.getLeft()).append(problem.toString()).append(OsUtils.LINE_SEPARATOR);
            if (!problem.hasChildren()) continue;
            String newIndent = (String)current.getLeft() + "  ";
            stack.addAll(problem.getChildren().stream().map(p -> Pair.of(newIndent, p)).collect(Collectors.toList()));
        }
        return builder.toString();
    }

    public static String debugString(List<Problem> problems) {
        return problems.stream().map(p -> Problem.debugString(p)).collect(Collectors.joining(OsUtils.LINE_SEPARATOR));
    }

    public List<Problem> getChildren() {
        return this.children.toList();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Problem(").append((Object)this.severity).append(": ").append(this.code.name());
        if (this.arguments.length > 0) {
            builder.append("[");
            boolean first = true;
            for (Object arg : this.arguments) {
                if (!first) {
                    builder.append(", ");
                }
                if (arg != null) {
                    builder.append("'").append(arg.toString()).append("'");
                } else {
                    builder.append("null");
                }
                first = false;
            }
            builder.append("]");
        }
        if (this.affected != null) {
            builder.append(" affected=").append(this.affected.toString());
        }
        if (this.exception != null) {
            builder.append(" exception=").append(this.exception);
        }
        if (this.children.isPresent()) {
            builder.append("children=").append(this.children.toString());
        }
        builder.append(")");
        return builder.toString();
    }

    public Throwable findAnyException() {
        if (this.exception != null) {
            return this.exception;
        }
        for (Problem child : this.children) {
            Throwable childCause = child.findAnyException();
            if (childCause == null) continue;
            return childCause;
        }
        return null;
    }

    @Override
    public Iterator<Problem> iterator() {
        return Iterators.singletonIterator((Object)this);
    }

    @Override
    public Optional<Problem> toProblem() {
        return Optional.of(this);
    }

    @Override
    public Stream<Problem> stream() {
        return Stream.of(this);
    }

    @Override
    public List<Problem> toList() {
        return List.of(this);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Generated
    public Problem(Severity severity, String defaultMessageFormat, Object[] arguments, Throwable exception, ProblemCode code, AffectedMetadata affected, Problems children) {
        this.severity = severity;
        this.defaultMessageFormat = defaultMessageFormat;
        this.arguments = arguments;
        this.exception = exception;
        this.code = code;
        this.affected = affected;
        this.children = children;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Problem)) {
            return false;
        }
        Problem other = (Problem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Severity this$severity = this.getSeverity();
        Severity other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !((Object)((Object)this$severity)).equals((Object)other$severity)) {
            return false;
        }
        String this$defaultMessageFormat = this.defaultMessageFormat;
        String other$defaultMessageFormat = other.defaultMessageFormat;
        if (this$defaultMessageFormat == null ? other$defaultMessageFormat != null : !this$defaultMessageFormat.equals(other$defaultMessageFormat)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getArguments(), other.getArguments())) {
            return false;
        }
        Throwable this$exception = this.getException();
        Throwable other$exception = other.getException();
        if (this$exception == null ? other$exception != null : !this$exception.equals(other$exception)) {
            return false;
        }
        ProblemCode this$code = this.getCode();
        ProblemCode other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        Optional<AffectedMetadata> this$affected = this.getAffected();
        Optional<AffectedMetadata> other$affected = other.getAffected();
        if (this$affected == null ? other$affected != null : !((Object)this$affected).equals(other$affected)) {
            return false;
        }
        List<Problem> this$children = this.getChildren();
        List<Problem> other$children = other.getChildren();
        return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Problem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Severity $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : ((Object)((Object)$severity)).hashCode());
        String $defaultMessageFormat = this.defaultMessageFormat;
        result = result * 59 + ($defaultMessageFormat == null ? 43 : $defaultMessageFormat.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getArguments());
        Throwable $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        ProblemCode $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        Optional<AffectedMetadata> $affected = this.getAffected();
        result = result * 59 + ($affected == null ? 43 : ((Object)$affected).hashCode());
        List<Problem> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        return result;
    }

    @Override
    @Generated
    public Severity getSeverity() {
        return this.severity;
    }

    @Generated
    public Object[] getArguments() {
        return this.arguments;
    }

    @Generated
    public Throwable getException() {
        return this.exception;
    }

    @Generated
    public ProblemCode getCode() {
        return this.code;
    }

    static class AffectedMetadata {
        private final Object underlyingObject;
        private final Class<?> underlyingClass;
        private final String name;

        public String toString() {
            if (this.underlyingObject == null) {
                return this.underlyingClass.toString() + ":" + this.name;
            }
            return this.underlyingObject.toString();
        }

        @Generated
        public AffectedMetadata(Object underlyingObject, Class<?> underlyingClass, String name) {
            this.underlyingObject = underlyingObject;
            this.underlyingClass = underlyingClass;
            this.name = name;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AffectedMetadata)) {
                return false;
            }
            AffectedMetadata other = (AffectedMetadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$underlyingObject = this.getUnderlyingObject();
            Object other$underlyingObject = other.getUnderlyingObject();
            if (this$underlyingObject == null ? other$underlyingObject != null : !this$underlyingObject.equals(other$underlyingObject)) {
                return false;
            }
            Class<?> this$underlyingClass = this.getUnderlyingClass();
            Class<?> other$underlyingClass = other.getUnderlyingClass();
            if (this$underlyingClass == null ? other$underlyingClass != null : !this$underlyingClass.equals(other$underlyingClass)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AffectedMetadata;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $underlyingObject = this.getUnderlyingObject();
            result = result * 59 + ($underlyingObject == null ? 43 : $underlyingObject.hashCode());
            Class<?> $underlyingClass = this.getUnderlyingClass();
            result = result * 59 + ($underlyingClass == null ? 43 : $underlyingClass.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public Object getUnderlyingObject() {
            return this.underlyingObject;
        }

        @Generated
        public Class<?> getUnderlyingClass() {
            return this.underlyingClass;
        }

        @Generated
        public String getName() {
            return this.name;
        }
    }

    public static enum Severity {
        INFO,
        WARNING,
        ERROR,
        FATAL;

    }
}

