/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.pipeline.ast;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.pipeline.ast.StepDeclaration;
import nz.org.riskscape.rl.TokenTypes;
import nz.org.riskscape.rl.ast.FunctionCall;

public class StepDefinition
extends StepDeclaration {
    private final FunctionCall step;
    @NonNull
    private final Optional<Token> nameToken;

    public StepDefinition(String id) {
        this(new FunctionCall(TokenTypes.identToken(id), Collections.emptyList()), Optional.empty(), Optional.empty());
    }

    public StepDefinition(FunctionCall fc, Optional<Token> nameToken, Optional<Token> namedInputToken) {
        super(fc.getIdentifier(), namedInputToken);
        this.step = fc;
        this.nameToken = nameToken;
    }

    public String getStepId() {
        return this.identToken.getValue();
    }

    public Optional<String> getName() {
        return this.nameToken.map(Token::getValue);
    }

    public List<FunctionCall.Argument> getStepParameters() {
        return this.step.getArguments();
    }

    public Token getStepIdToken() {
        return this.step.getIdentifier();
    }

    @Override
    public Optional<Pair<Token, Token>> getBoundary() {
        return this.step.getBoundary().map(stepBoundary -> Pair.of((Token)stepBoundary.getLeft(), this.nameToken.orElse((Token)stepBoundary.getRight())));
    }

    @Override
    protected void appendSource(StringBuilder appendTo) {
        appendTo.append(this.step.toSource());
        if (this.nameToken.isPresent()) {
            appendTo.append(" as ").append(this.nameToken.get().rawValue());
        }
    }

    @Override
    protected void appendString(StringBuilder appendTo) {
        if (!this.nameToken.isPresent()) {
            appendTo.append("?");
        }
        appendTo.append(this.getName().orElse(this.getIdent())).append("(");
        if (!this.step.getArguments().isEmpty()) {
            appendTo.append("\u2026");
        }
        appendTo.append(")");
        if (this.namedInputToken.isPresent()) {
            appendTo.append(".").append(((Token)this.namedInputToken.get()).getValue());
        }
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StepDefinition)) {
            return false;
        }
        StepDefinition other = (StepDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FunctionCall this$step = this.getStep();
        FunctionCall other$step = other.getStep();
        if (this$step == null ? other$step != null : !((Object)this$step).equals(other$step)) {
            return false;
        }
        Optional<Token> this$nameToken = this.getNameToken();
        Optional<Token> other$nameToken = other.getNameToken();
        return !(this$nameToken == null ? other$nameToken != null : !((Object)this$nameToken).equals(other$nameToken));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StepDefinition;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FunctionCall $step = this.getStep();
        result = result * 59 + ($step == null ? 43 : ((Object)$step).hashCode());
        Optional<Token> $nameToken = this.getNameToken();
        result = result * 59 + ($nameToken == null ? 43 : ((Object)$nameToken).hashCode());
        return result;
    }

    @Generated
    public FunctionCall getStep() {
        return this.step;
    }

    @NonNull
    @Generated
    public Optional<Token> getNameToken() {
        return this.nameToken;
    }
}

