/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.pipeline.ast;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.engine.OsUtils;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.pipeline.ast.BaseExpr;
import nz.org.riskscape.pipeline.ast.StepDeclaration;
import nz.org.riskscape.pipeline.ast.StepLink;
import nz.org.riskscape.rl.TokenTypes;
import nz.org.riskscape.util.ListUtils;

public class StepChain
extends BaseExpr {
    public static final Token CHAIN_TOKEN = Token.token(TokenTypes.CHAIN, "->");
    public static final StepChain EMPTY = new StepChain(Collections.emptyList(), Collections.emptyList());
    private final List<StepDeclaration> steps;
    private final List<Token> links;

    public StepChain(List<StepDeclaration> steps) {
        this(steps, Collections.nCopies(steps.size() - 1, CHAIN_TOKEN));
    }

    public StepChain(List<StepDeclaration> steps, List<Token> links) {
        this.steps = ImmutableList.copyOf(steps);
        this.links = ImmutableList.copyOf(links);
    }

    @Override
    public Optional<Pair<Token, Token>> getBoundary() {
        if (this.steps.isEmpty()) {
            return Optional.empty();
        }
        StepDeclaration first = this.steps.get(0);
        StepDeclaration last = this.steps.get(this.steps.size() - 1);
        return first.getBoundary().flatMap(firstPair -> last.getBoundary().map(lastPair -> Pair.of((Token)firstPair.getLeft(), (Token)lastPair.getRight())));
    }

    public StepChain append(StepChain appendStepsFrom) {
        return new StepChain(ListUtils.concat(this.steps, appendStepsFrom.steps));
    }

    public StepChain append(StepDeclaration stepDeclaration) {
        return new StepChain(ListUtils.append(this.steps, stepDeclaration));
    }

    @Override
    protected void appendSource(StringBuilder appendTo) {
        boolean first = true;
        for (StepDeclaration decl : this.steps) {
            if (!first) {
                appendTo.append(OsUtils.LINE_SEPARATOR);
                appendTo.append(" -> ");
            }
            decl.appendSource(appendTo);
            first = false;
        }
    }

    @Override
    protected void appendString(StringBuilder appendTo) {
        boolean first = true;
        for (StepDeclaration stepDeclaration : this.steps) {
            if (!first) {
                appendTo.append(" -> ");
            }
            stepDeclaration.appendString(appendTo);
            first = false;
        }
    }

    public StepDeclaration getFirst() {
        return this.steps.get(0);
    }

    public StepDeclaration getLast() {
        return this.steps.get(this.steps.size() - 1);
    }

    public StepLink getLink(int index) {
        if (index >= this.getLinkCount()) {
            throw new NoSuchElementException("this chain has only " + this.getLinkCount() + " links");
        }
        return new StepLink(this.steps.get(index), this.links.get(index), this.steps.get(index + 1));
    }

    public int getLinkCount() {
        return this.size() - 1;
    }

    public int size() {
        return this.steps.size();
    }

    public StepChain replace(StepDeclaration step, StepDeclaration replacement) {
        if (!this.steps.contains(step)) {
            throw new IllegalArgumentException("This chain does not contain " + String.valueOf(step));
        }
        ArrayList<StepDeclaration> newSteps = new ArrayList<StepDeclaration>(this.steps);
        newSteps.set(newSteps.indexOf(step), replacement);
        return new StepChain(List.copyOf(newSteps), this.links);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StepChain)) {
            return false;
        }
        StepChain other = (StepChain)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<StepDeclaration> this$steps = this.getSteps();
        List<StepDeclaration> other$steps = other.getSteps();
        if (this$steps == null ? other$steps != null : !((Object)this$steps).equals(other$steps)) {
            return false;
        }
        List<Token> this$links = this.links;
        List<Token> other$links = other.links;
        return !(this$links == null ? other$links != null : !((Object)this$links).equals(other$links));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StepChain;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<StepDeclaration> $steps = this.getSteps();
        result = result * 59 + ($steps == null ? 43 : ((Object)$steps).hashCode());
        List<Token> $links = this.links;
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        return result;
    }

    @Generated
    public List<StepDeclaration> getSteps() {
        return this.steps;
    }
}

