/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.pipeline.ast;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.dsl.SourceLocation;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.engine.OsUtils;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.pipeline.PipelineProblems;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.pipeline.PipelineMetadata;
import nz.org.riskscape.pipeline.PipelineParser;
import nz.org.riskscape.pipeline.StepNamingPolicy;
import nz.org.riskscape.pipeline.ast.BaseExpr;
import nz.org.riskscape.pipeline.ast.StepChain;
import nz.org.riskscape.pipeline.ast.StepDeclaration;
import nz.org.riskscape.pipeline.ast.StepDefinition;
import nz.org.riskscape.pipeline.ast.StepLink;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.MinimalVisitor;
import nz.org.riskscape.rl.ast.ParameterToken;
import nz.org.riskscape.util.ListUtils;

public final class PipelineDeclaration
extends BaseExpr {
    public static final PipelineDeclaration EMPTY = new PipelineDeclaration(Collections.emptyList());
    private final List<StepChain> chains;
    private final PipelineMetadata metadata;

    public PipelineDeclaration(List<StepChain> chains) {
        this.chains = chains;
        this.metadata = PipelineMetadata.ANONYMOUS;
    }

    @Override
    public Optional<Pair<Token, Token>> getBoundary() {
        if (this.chains.isEmpty()) {
            return Optional.empty();
        }
        StepChain first = this.chains.get(0);
        StepChain last = this.chains.get(this.chains.size() - 1);
        return first.getBoundary().flatMap(firstPair -> last.getBoundary().map(lastPair -> Pair.of((Token)firstPair.getLeft(), (Token)lastPair.getRight())));
    }

    public Optional<Found> findDefinition(@NonNull String stepName) {
        if (stepName == null) {
            throw new NullPointerException("stepName is marked non-null but is null");
        }
        return this.find((StepChain chain, StepDeclaration decl) -> decl.isA(StepDefinition.class).flatMap(StepDefinition::getName).map(name -> name.equals(stepName)).orElse(false));
    }

    public Optional<Found> find(Predicate<StepDeclaration> predicate) {
        return this.find((StepChain ignored, StepDeclaration step) -> predicate.test((StepDeclaration)step));
    }

    public Optional<Found> find(BiPredicate<StepChain, StepDeclaration> predicate) {
        for (StepChain stepChain : this.chains) {
            for (StepDeclaration declaration : stepChain.getSteps()) {
                if (!predicate.test(stepChain, declaration)) continue;
                return Optional.of(new Found(this, stepChain, declaration));
            }
        }
        return Optional.empty();
    }

    public List<Found> findAll(BiPredicate<StepChain, StepDeclaration> predicate) {
        LinkedList<Found> collected = new LinkedList<Found>();
        for (StepChain stepChain : this.chains) {
            for (StepDeclaration declaration : stepChain.getSteps()) {
                if (!predicate.test(stepChain, declaration)) continue;
                collected.add(new Found(this, stepChain, declaration));
            }
        }
        return collected;
    }

    public PipelineDeclaration replace(@NonNull StepChain found, @NonNull StepChain newChain) throws IllegalStateException {
        if (found == null) {
            throw new NullPointerException("found is marked non-null but is null");
        }
        if (newChain == null) {
            throw new NullPointerException("newChain is marked non-null but is null");
        }
        ArrayList<StepChain> clone = new ArrayList<StepChain>(this.chains);
        int index = clone.indexOf(found);
        if (index < 0) {
            throw new IllegalStateException("chain not a member of this declaration");
        }
        clone.set(index, newChain);
        return new PipelineDeclaration(clone);
    }

    public Map<ParameterToken, List<StepDefinition>> findParameters() {
        final LinkedHashMap<ParameterToken, List<StepDefinition>> tokens = new LinkedHashMap<ParameterToken, List<StepDefinition>>();
        MinimalVisitor<StepDefinition> tokenVisitor = new MinimalVisitor<StepDefinition>(){

            @Override
            public StepDefinition visit(ParameterToken parameterToken, StepDefinition data) {
                tokens.compute(parameterToken, (k, v) -> {
                    List list;
                    List list2 = list = v == null ? new LinkedList() : v;
                    if (!list.contains(data)) {
                        list.add(data);
                    }
                    return list;
                });
                return null;
            }
        };
        Iterator<StepDefinition> iterator = this.stepDefinitionIterator();
        while (iterator.hasNext()) {
            StepDefinition defn = iterator.next();
            defn.getStep().accept(tokenVisitor, defn);
        }
        return tokens;
    }

    public ResultOrProblems<PipelineDeclaration> replaceParameters(Map<String, Expression> replacements) {
        Optional<Pair<Token, Token>> boundary = this.getBoundary();
        Object pipelineWithParamValues = !boundary.isPresent() ? this.toSource() : boundary.get().getLeft().source;
        ArrayList parameterTokens = new ArrayList();
        MinimalVisitor<List<ParameterToken>> tokenCollector = new MinimalVisitor<List<ParameterToken>>(){

            @Override
            public List<ParameterToken> visit(ParameterToken parameterToken, List<ParameterToken> tokens) {
                tokens.add(parameterToken);
                return tokens;
            }
        };
        Iterator<StepDefinition> stepIterator = this.stepDefinitionIterator();
        while (stepIterator.hasNext()) {
            StepDefinition defn = stepIterator.next();
            defn.getStep().accept(tokenCollector, parameterTokens);
        }
        LinkedList<ParameterToken> unresolved = new LinkedList<ParameterToken>();
        for (int i = parameterTokens.size() - 1; i >= 0; --i) {
            ParameterToken token2 = (ParameterToken)parameterTokens.get(i);
            Expression paramExpr = replacements.get(token2.getValue());
            if (paramExpr == null) {
                unresolved.add(token2);
                continue;
            }
            String beforeParam = ((String)pipelineWithParamValues).substring(0, token2.getBoundary().get().getLeft().begin);
            String afterParam = ((String)pipelineWithParamValues).substring(token2.getBoundary().get().getRight().end, ((String)pipelineWithParamValues).length());
            String paramSource = paramExpr.getBoundary().map(paramBoundary -> ((Token)paramBoundary.getLeft()).source.substring(((Token)paramBoundary.getLeft()).begin, ((Token)paramBoundary.getRight()).end)).orElse(paramExpr.toSource());
            pipelineWithParamValues = beforeParam + paramSource + afterParam;
        }
        if (unresolved.size() > 0) {
            return ResultOrProblems.failed(unresolved.stream().map(token -> Problems.foundWith(token, (Problems)GeneralProblems.required(token.getValue(), Parameter.class))).toList());
        }
        return ResultOrProblems.of(PipelineParser.INSTANCE.parsePipelineAllowParameters((String)pipelineWithParamValues).withMetadata(this.getMetadata()));
    }

    public PipelineDeclaration add(@NonNull StepChain toAdd) {
        if (toAdd == null) {
            throw new NullPointerException("toAdd is marked non-null but is null");
        }
        return new PipelineDeclaration(ListUtils.concat(this.chains, Collections.singletonList(toAdd)));
    }

    public PipelineDeclaration add(PipelineDeclaration toAdd) {
        return new PipelineDeclaration(ListUtils.concat(this.chains, toAdd.chains));
    }

    public StepChain getFirst() {
        return this.chains.get(0);
    }

    public StepChain getLast() {
        return this.chains.get(this.chains.size() - 1);
    }

    public boolean isEmpty() {
        return this.chains.size() == 0;
    }

    @Override
    protected void appendString(StringBuilder appendTo) {
        boolean first = true;
        for (StepChain stepChain : this.chains) {
            if (!first) {
                appendTo.append(", ");
            }
            stepChain.appendString(appendTo);
            first = false;
        }
    }

    @Override
    protected void appendSource(StringBuilder appendTo) {
        boolean first = true;
        for (StepChain stepChain : this.chains) {
            if (!first) {
                appendTo.append(OsUtils.LINE_SEPARATOR);
            }
            stepChain.appendSource(appendTo);
            first = false;
        }
    }

    public Iterator<StepDefinition> stepDefinitionIterator() {
        return new StepDefnIterator();
    }

    public int size() {
        return this.chains.size();
    }

    public Function<StepDeclaration, String> getStepNameFunction(StepNamingPolicy policy) {
        return StepNamingPolicy.broaden(policy.getStepNameFunction(this));
    }

    public ResultOrProblems<PipelineDeclaration> checkValid(Function<StepDeclaration, String> nameFunction) {
        return this.checkStepRefinition().flatMap(pipeline -> this.detectCycles(nameFunction));
    }

    private ResultOrProblems<PipelineDeclaration> checkStepRefinition() {
        ArrayList problems = Lists.newArrayList();
        HashMap<String, StepDefinition> userNamedSteps = new HashMap<String, StepDefinition>();
        Iterator<StepDefinition> definitions = this.stepDefinitionIterator();
        while (definitions.hasNext()) {
            StepDefinition toAdd = definitions.next();
            if (!toAdd.getName().isPresent()) continue;
            String name = toAdd.getName().get();
            StepDefinition existing = (StepDefinition)userNamedSteps.get(name);
            if (existing == null) {
                userNamedSteps.put(name, toAdd);
                continue;
            }
            SourceLocation firstDefinition = existing.getNameToken().orElse(existing.getIdentToken()).getLocation();
            problems.add(PipelineProblems.get().stepRedefinition(name, firstDefinition, toAdd.getNameToken().get().getLocation()));
        }
        if (!problems.isEmpty()) {
            return ResultOrProblems.failed(problems);
        }
        return ResultOrProblems.of(this);
    }

    private ResultOrProblems<PipelineDeclaration> detectCycles(Function<StepDeclaration, String> nameFunc) {
        LinkedList<StepLink> unseen = new LinkedList<StepLink>();
        for (StepChain stepChain : this.chains) {
            for (int i = 0; i < stepChain.getLinkCount(); ++i) {
                StepLink link = stepChain.getLink(i);
                unseen.add(link);
            }
        }
        while (!unseen.isEmpty()) {
            StepLink node = (StepLink)unseen.removeFirst();
            LinkedList<StackEl> visitList = new LinkedList<StackEl>();
            LinkedList<StackEl> stack = new LinkedList<StackEl>();
            visitList.add(new StackEl(node, 0));
            stack.add(new StackEl(new StepLink(node.getLhs(), null, node.getLhs()), 0));
            while (!visitList.isEmpty()) {
                StackEl visiting = (StackEl)visitList.removeLast();
                unseen.remove(visiting.edge);
                while (stack.size() > 0 && ((StackEl)stack.getLast()).depth > visiting.depth) {
                    stack.removeLast();
                }
                StackEl alreadySeen = stack.stream().filter(pair -> {
                    String stackName = (String)nameFunc.apply(pair.edge.getRhs());
                    String visitingName = (String)nameFunc.apply(visiting.edge.getRhs());
                    return stackName.equals(visitingName);
                }).findFirst().orElse(null);
                if (alreadySeen != null) {
                    StepLink offendingEdge = visiting.edge;
                    return ResultOrProblems.failed(PipelineProblems.get().cycleDetected(offendingEdge.toSource(), offendingEdge.getChain().getLocation(), offendingEdge.getRhs().toSource(), alreadySeen.edge.getRhs().getIdentToken().getLocation()));
                }
                stack.addLast(visiting);
                ListIterator unseenIter = unseen.listIterator();
                while (unseenIter.hasNext()) {
                    String toName;
                    StepLink candidate = (StepLink)unseenIter.next();
                    String fromName = nameFunc.apply(candidate.getLhs());
                    if (!fromName.equals(toName = nameFunc.apply(visiting.edge.getRhs()))) continue;
                    visitList.addLast(new StackEl(candidate, visiting.depth + 1));
                }
            }
        }
        return ResultOrProblems.of(this);
    }

    public PipelineDeclaration withMetadata(PipelineMetadata newMetadata) {
        return new PipelineDeclaration(this.chains, newMetadata);
    }

    @Generated
    public PipelineDeclaration(List<StepChain> chains, PipelineMetadata metadata) {
        this.chains = chains;
        this.metadata = metadata;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PipelineDeclaration)) {
            return false;
        }
        PipelineDeclaration other = (PipelineDeclaration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<StepChain> this$chains = this.getChains();
        List<StepChain> other$chains = other.getChains();
        if (this$chains == null ? other$chains != null : !((Object)this$chains).equals(other$chains)) {
            return false;
        }
        PipelineMetadata this$metadata = this.getMetadata();
        PipelineMetadata other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PipelineDeclaration;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<StepChain> $chains = this.getChains();
        result = result * 59 + ($chains == null ? 43 : ((Object)$chains).hashCode());
        PipelineMetadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    @Generated
    public List<StepChain> getChains() {
        return this.chains;
    }

    @Generated
    public PipelineMetadata getMetadata() {
        return this.metadata;
    }

    public static class Found {
        private final PipelineDeclaration pipeline;
        private final StepChain chain;
        private final StepDeclaration step;

        public static Found last(PipelineDeclaration decl, StepChain chain) {
            return new Found(decl, chain, chain.getLast());
        }

        public static Found last(PipelineDeclaration decl) {
            return new Found(decl, decl.getLast(), decl.getLast().getLast());
        }

        public PipelineDeclaration append(StepChain newChain) {
            return this.pipeline.replace(this.chain, this.chain.append(newChain));
        }

        public int getChainIndex() {
            return this.pipeline.chains.indexOf(this.chain);
        }

        public PipelineDeclaration replace(StepDeclaration replacement) {
            StepChain newChain = this.chain.replace(this.step, replacement);
            return this.pipeline.replace(this.chain, newChain);
        }

        @Generated
        public Found(PipelineDeclaration pipeline, StepChain chain, StepDeclaration step) {
            this.pipeline = pipeline;
            this.chain = chain;
            this.step = step;
        }

        @Generated
        public PipelineDeclaration getPipeline() {
            return this.pipeline;
        }

        @Generated
        public StepChain getChain() {
            return this.chain;
        }

        @Generated
        public StepDeclaration getStep() {
            return this.step;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Found)) {
                return false;
            }
            Found other = (Found)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PipelineDeclaration this$pipeline = this.getPipeline();
            PipelineDeclaration other$pipeline = other.getPipeline();
            if (this$pipeline == null ? other$pipeline != null : !((Object)this$pipeline).equals(other$pipeline)) {
                return false;
            }
            StepChain this$chain = this.getChain();
            StepChain other$chain = other.getChain();
            if (this$chain == null ? other$chain != null : !((Object)this$chain).equals(other$chain)) {
                return false;
            }
            StepDeclaration this$step = this.getStep();
            StepDeclaration other$step = other.getStep();
            return !(this$step == null ? other$step != null : !((Object)this$step).equals(other$step));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Found;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PipelineDeclaration $pipeline = this.getPipeline();
            result = result * 59 + ($pipeline == null ? 43 : ((Object)$pipeline).hashCode());
            StepChain $chain = this.getChain();
            result = result * 59 + ($chain == null ? 43 : ((Object)$chain).hashCode());
            StepDeclaration $step = this.getStep();
            result = result * 59 + ($step == null ? 43 : ((Object)$step).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PipelineDeclaration.Found(pipeline=" + String.valueOf(this.getPipeline()) + ", chain=" + String.valueOf(this.getChain()) + ", step=" + String.valueOf(this.getStep()) + ")";
        }
    }

    private class StepDefnIterator
    implements Iterator<StepDefinition> {
        private int chainIndex = 0;
        private int stepIndex = 0;
        private StepDefinition peeked = null;

        private StepDefnIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.peek(false) != null;
        }

        @Override
        public StepDefinition next() {
            return this.peek(true);
        }

        private StepDefinition peek(boolean consume) {
            while (this.peeked == null && this.chainIndex < PipelineDeclaration.this.chains.size()) {
                StepChain currentChain = PipelineDeclaration.this.chains.get(this.chainIndex);
                if (this.stepIndex < currentChain.size()) {
                    StepDeclaration decl = currentChain.getSteps().get(this.stepIndex++);
                    if (!(decl instanceof StepDefinition)) continue;
                    this.peeked = (StepDefinition)decl;
                    break;
                }
                this.stepIndex = 0;
                ++this.chainIndex;
            }
            StepDefinition toReturn = this.peeked;
            if (consume) {
                if (this.peeked == null) {
                    throw new NoSuchElementException();
                }
                this.peeked = null;
            }
            return toReturn;
        }
    }

    private static final class StackEl {
        final StepLink edge;
        final int depth;

        @Generated
        public StackEl(StepLink edge, int depth) {
            this.edge = edge;
            this.depth = depth;
        }
    }
}

