/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.pipeline;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Optional;
import nz.org.riskscape.dsl.ConditionalParse;
import nz.org.riskscape.dsl.Lexer;
import nz.org.riskscape.dsl.LexerException;
import nz.org.riskscape.dsl.ParseException;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.engine.RiskscapeIOException;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.pipeline.PipelineMetadata;
import nz.org.riskscape.pipeline.ast.PipelineDeclaration;
import nz.org.riskscape.pipeline.ast.StepChain;
import nz.org.riskscape.pipeline.ast.StepDeclaration;
import nz.org.riskscape.pipeline.ast.StepDefinition;
import nz.org.riskscape.pipeline.ast.StepReference;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ExpressionParser;
import nz.org.riskscape.rl.TokenTypes;
import nz.org.riskscape.rl.ast.FunctionCall;

public class PipelineParser {
    public static final PipelineParser INSTANCE = new PipelineParser();

    public static ResultOrProblems<PipelineDeclaration> parseParameterizedPipeline(Resource source) {
        return PipelineParser.parsePipeline(source, true);
    }

    public static ResultOrProblems<PipelineDeclaration> parsePipeline(Resource source) {
        return PipelineParser.parsePipeline(source, false);
    }

    private static ResultOrProblems<PipelineDeclaration> parsePipeline(Resource source, boolean allowParameters) {
        try {
            return ResultOrProblems.of(INSTANCE.parsePipeline(source.getContentAsString(), allowParameters).withMetadata(PipelineMetadata.ANONYMOUS.withLocation(source.getLocation())));
        }
        catch (LexerException | ParseException | RiskscapeIOException e) {
            return ResultOrProblems.failed(Problems.caught(e));
        }
    }

    public PipelineDeclaration parsePipeline(String pipelineSource) {
        return this.parsePipeline(pipelineSource, false);
    }

    public PipelineDeclaration parsePipelineAllowParameters(String pipelineSource) {
        return this.parsePipeline(pipelineSource, true);
    }

    private PipelineDeclaration parsePipeline(String pipelineSource, boolean allowParameters) {
        Lexer<TokenTypes> lexer = new Lexer<TokenTypes>(TokenTypes.tokens(), pipelineSource);
        LinkedList<StepChain> chains = new LinkedList<StepChain>();
        LinkedList<StepDeclaration> stepChain = null;
        LinkedList<Token> links = null;
        while (lexer.peekType() != TokenTypes.EOF) {
            StepDeclaration currentStep = this.parseStep(lexer, allowParameters);
            if (stepChain == null) {
                stepChain = new LinkedList<StepDeclaration>();
                links = new LinkedList<Token>();
            }
            stepChain.add(currentStep);
            Optional<Token> chaining = lexer.consumeIf(TokenTypes.CHAIN);
            if (!chaining.isPresent()) {
                chains.add(new StepChain(stepChain, links));
                stepChain = null;
                continue;
            }
            links.add(chaining.get());
        }
        if (stepChain != null) {
            lexer.expect(TokenTypes.IDENTIFIER, TokenTypes.QUOTED_IDENTIFIER);
        }
        lexer.expect(TokenTypes.EOF);
        return new PipelineDeclaration(chains);
    }

    StepDeclaration parseStep(Lexer<TokenTypes> lexer, boolean allowParameters) {
        StepDeclaration parsed = (StepDeclaration)lexer.tryThese(ConditionalParse.parseIf("function-expression", Arrays.asList(ExpressionParser.IDENTIFIERS, EnumSet.of(TokenTypes.LPAREN)), () -> this.parseStepDefinition(lexer, allowParameters)), ConditionalParse.parseIf("property-access", Arrays.asList(ExpressionParser.IDENTIFIERS), () -> this.parseStepReference(lexer)));
        return parsed;
    }

    private StepReference parseStepReference(Lexer<TokenTypes> lexer) {
        Optional<Token> namedInput;
        Token stepName = lexer.expect(TokenTypes.IDENTIFIER, TokenTypes.QUOTED_IDENTIFIER);
        if (lexer.peekType() == TokenTypes.INDEX) {
            lexer.next();
            namedInput = Optional.of(lexer.expect(TokenTypes.IDENTIFIER, TokenTypes.QUOTED_IDENTIFIER));
        } else {
            namedInput = Optional.empty();
        }
        return new StepReference(stepName, namedInput);
    }

    StepDefinition parseStepDefinition(Lexer<TokenTypes> lexer, boolean allowParameters) {
        FunctionCall fc = ExpressionParser.INSTANCE.parseFunctionExpression(lexer);
        if (!allowParameters) {
            ExpressionParser.INSTANCE.checkForParameters(fc);
        }
        Optional<Token> inputName = lexer.consumeIf(TokenTypes.INDEX).map(as -> lexer.expect(TokenTypes.IDENTIFIER, TokenTypes.QUOTED_IDENTIFIER));
        Optional<Token> name = lexer.consumeIf(TokenTypes.KEYWORD_AS).map(as -> lexer.expect(TokenTypes.IDENTIFIER, TokenTypes.QUOTED_IDENTIFIER));
        return new StepDefinition(fc, name, inputName);
    }
}

