/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.ini;

import nz.org.riskscape.dsl.LexerException;
import nz.org.riskscape.dsl.LexerProblems;
import nz.org.riskscape.dsl.LexingMatcher;
import nz.org.riskscape.dsl.LexingStream;
import nz.org.riskscape.dsl.SourceLocation;

class TokenMatchers {
    private static final char[] QUOTE_CHARS = "'\"`".toCharArray();
    private static final char[] SPACE_OR_TAB = " \t".toCharArray();
    public static final LexingMatcher VALUE = (tokenType, stream) -> {
        SourceLocation startsAt = stream.nextIf("=");
        if (startsAt == null) {
            return null;
        }
        stream.skipWhile(SPACE_OR_TAB);
        StringBuilder builder = new StringBuilder();
        boolean eatWhiteSpace = false;
        while (!stream.isEof()) {
            if (eatWhiteSpace) {
                stream.skipWhile(SPACE_OR_TAB);
                eatWhiteSpace = false;
                continue;
            }
            if (TokenMatchers.skipIfLineEnding(stream)) break;
            char lastChar = stream.getLastChar();
            char ch = stream.next();
            if (TokenMatchers.isTrailingComment(ch, lastChar)) {
                while (!stream.isEof() && !TokenMatchers.skipIfLineEnding(stream)) {
                    stream.next();
                }
                break;
            }
            if (TokenMatchers.skipIfEscapedLineEnding(ch, stream)) {
                eatWhiteSpace = true;
                continue;
            }
            builder.append(ch);
        }
        return stream.newToken(tokenType, startsAt, builder.toString());
    };
    public static final LexingMatcher MULTILINE_VALUE = (tokenType, stream) -> {
        SourceLocation startsAt = stream.nextIf("=");
        if (startsAt == null) {
            return null;
        }
        stream.skipWhile(SPACE_OR_TAB);
        char quoteChar = stream.nextIfOneOf(QUOTE_CHARS);
        if (quoteChar == '\u0000') {
            return null;
        }
        if (!stream.nextIf(quoteChar)) {
            return null;
        }
        if (!stream.nextIf(quoteChar)) {
            return null;
        }
        int quoteCount = 0;
        StringBuilder buffer = new StringBuilder();
        stream.skipWhile(SPACE_OR_TAB);
        TokenMatchers.eatNewLine(stream);
        while (!stream.isEof()) {
            char ch = stream.next();
            if (ch == quoteChar) {
                if (++quoteCount != 3) continue;
                return stream.newToken(tokenType, startsAt, buffer.toString());
            }
            if (quoteCount > 0) {
                while (quoteCount > 0) {
                    buffer.append(quoteChar);
                    --quoteCount;
                }
                buffer.append(ch);
                continue;
            }
            buffer.append(ch);
        }
        throw new LexerException(LexerProblems.get().eofInString(stream.getIndex()));
    };

    TokenMatchers() {
    }

    private static boolean skipIfLineEnding(LexingStream stream) {
        char c = stream.peek();
        if (c == '\r' || c == '\n') {
            stream.next();
            if (c == '\r' && stream.peek() == '\n') {
                stream.next();
            }
            return true;
        }
        return false;
    }

    private static boolean skipIfEscapedLineEnding(char ch, LexingStream stream) {
        if (ch != '\\') {
            return false;
        }
        SourceLocation start = stream.getLocation();
        stream.skipWhile(SPACE_OR_TAB);
        if (!TokenMatchers.skipIfLineEnding(stream)) {
            stream.rewind(start);
            return false;
        }
        return true;
    }

    private static boolean isTrailingComment(char currentChar, char lastChar) {
        if (currentChar == '#' || currentChar == ';') {
            return lastChar == ' ' || lastChar == '\t';
        }
        return false;
    }

    private static void eatNewLine(LexingStream stream) {
        char ch = stream.peek();
        if (ch == '\r') {
            stream.next();
        }
        if (ch == '\n') {
            stream.next();
        }
    }
}

