/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.ini;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import nz.org.riskscape.dsl.Lexer;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.ini.IniFile;
import nz.org.riskscape.ini.IniTokens;
import nz.org.riskscape.ini.KeyValue;
import nz.org.riskscape.ini.Section;

public class IniParser2 {
    private Lexer<IniTokens> lexer;

    public IniFile parse(String source) {
        this.lexer = new Lexer<IniTokens>(IniTokens.tokens(), source);
        List<KeyValue> anonymous = Collections.emptyList();
        LinkedList<Section> sections = new LinkedList<Section>();
        while (!this.lexer.isEOF()) {
            if (this.lexer.peekType() == IniTokens.SECTION) {
                sections.add(this.parseSection());
                continue;
            }
            anonymous = this.parseKeyValues();
        }
        return new IniFile(anonymous, sections);
    }

    private List<KeyValue> parseKeyValues() {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        while (this.lexer.peekType() == IniTokens.KEY) {
            Token key = this.lexer.expect(IniTokens.KEY);
            Token value = this.lexer.expect(IniTokens.VALUE, IniTokens.MULTILINE_VALUE);
            keyValues.add(new KeyValue(key, value));
        }
        return keyValues;
    }

    private Section parseSection() {
        Token section = this.lexer.expect(IniTokens.SECTION);
        return new Section(section, this.parseKeyValues());
    }
}

