/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.util;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.IntStream;
import nz.org.riskscape.engine.RandomSingleton;

public class RandomUtils {
    public static List<Double> getNormalVariate(double mean, double stddev, Optional<Long> seed, int numSamples) {
        Random rng = RandomSingleton.get(seed);
        return IntStream.range(0, numSamples).mapToDouble(i -> stddev * rng.nextGaussian() + mean).boxed().toList();
    }

    public static double getNormalVariate(double mean, double stddev) {
        return RandomUtils.getNormalVariate(mean, stddev, Optional.empty(), 1).get(0);
    }

    public static List<Double> getFromRange(double start, double stop, Optional<Long> seed, int numSamples) {
        Random rng = RandomSingleton.get(seed);
        return IntStream.range(0, numSamples).mapToDouble(i -> start + (stop - start) * rng.nextDouble()).boxed().toList();
    }

    public static double getFromRange(double start, double stop) {
        return RandomUtils.getFromRange(start, stop, Optional.empty(), 1).get(0);
    }

    public static Object pick(List<?> items, List<Double> weights, Optional<Long> seed) {
        if (weights.size() != items.size()) {
            throw new IllegalArgumentException("'items' and 'weights' lists must be the same size");
        }
        double totalWeight = weights.stream().mapToDouble(val -> val).sum();
        double randomWeight = RandomSingleton.get(seed).nextDouble() * totalWeight;
        double currentWeight = 0.0;
        for (int i = 0; i < items.size(); ++i) {
            if (!((currentWeight += weights.get(i).doubleValue()) >= randomWeight)) continue;
            return items.get(i);
        }
        return null;
    }

    public static Object pick(List<?> items, List<Double> weights) {
        return RandomUtils.pick(items, weights, Optional.empty());
    }

    public static Object pick(List<?> items, Optional<Long> seed) {
        if (items.isEmpty()) {
            return null;
        }
        int randomIndex = RandomSingleton.get(seed).nextInt(items.size());
        return items.get(randomIndex);
    }

    public static Object pick(List<?> items) {
        return RandomUtils.pick(items, Optional.empty());
    }
}

