/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.typexp;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.typeset.TypeSet;
import nz.org.riskscape.engine.typexp.AST;
import nz.org.riskscape.engine.typexp.TypeArgumentException;

public interface TypeBuilder {
    public Type build(String var1);

    public Type buildSimpleType(AST.Symbol var1);

    public Type buildComplexType(AST.ComplexType var1);

    public TypeSet getTypeSet();

    default public Type expectType(AST ast, Function<AST, RuntimeException> orElse) {
        if (ast instanceof AST.Symbol) {
            AST.Symbol symbol = (AST.Symbol)ast;
            return this.buildSimpleType(symbol);
        }
        if (ast instanceof AST.ComplexType) {
            return this.buildComplexType((AST.ComplexType)ast);
        }
        throw orElse.apply(ast);
    }

    default public Object expectConstant(AST ast, Function<AST, RuntimeException> orElse) {
        if (ast instanceof AST.Constant) {
            return ((AST.Constant)ast).toNative();
        }
        throw orElse.apply(ast);
    }

    default public List<Object> expectConstantsOfType(AST.ComplexType complexType, Type subType, List<AST> args, int argOffset) {
        ArrayList<Object> values = new ArrayList<Object>(args.size());
        for (AST ast : args) {
            Object coerced;
            int index = values.size() + argOffset;
            Object constant = this.expectConstant(ast, arg -> new TypeArgumentException(complexType, String.format("argument %d expected to be a constant", index)));
            try {
                coerced = subType.coerce(constant);
            }
            catch (CoercionException ex) {
                throw new TypeArgumentException(complexType, String.format("Argument %d could not be coerced to %s - %s", index, subType, ast));
            }
            values.add(coerced);
        }
        return values;
    }

    default public <T extends AST> T expectAST(Class<T> expectedASTClass, AST ast, Function<AST, RuntimeException> orElse) {
        if (expectedASTClass.isInstance(ast)) {
            return (T)((AST)expectedASTClass.cast(ast));
        }
        throw orElse.apply(ast);
    }
}

