/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.typexp;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import nz.org.riskscape.dsl.Token;

public abstract class AST {
    public final Token value;

    @Generated
    public AST(Token value) {
        this.value = value;
    }

    @Generated
    public String toString() {
        return "AST(value=" + String.valueOf(this.value) + ")";
    }

    public static class Dictionary
    extends AST {
        public final Map<Symbol, AST> values;

        public Dictionary(Token value, Map<Symbol, AST> values) {
            super(value);
            this.values = values;
        }

        public AST get(String identifier) {
            return this.values.entrySet().stream().filter(e -> ((Symbol)e.getKey()).ident().equals(identifier)).findFirst().map(entry -> (AST)entry.getValue()).orElse(null);
        }
    }

    public static class ValueList
    extends AST {
        public final List<AST> values;

        public ValueList(Token value, List<AST> values) {
            super(value);
            this.values = values;
        }
    }

    public static class ComplexType
    extends AST {
        final ValueList arguments;

        public ComplexType(Token value, ValueList arguments) {
            super(value);
            this.arguments = arguments;
        }

        public String ident() {
            return this.value.value;
        }

        public int argCount() {
            return this.arguments.values.size();
        }

        public AST arg(int i) {
            return this.arguments.values.get(i);
        }

        public List<AST> args() {
            return Lists.newArrayList(this.arguments.values);
        }
    }

    public static class Symbol
    extends AST {
        public Symbol(Token value) {
            super(value);
        }

        public String ident() {
            return this.value.value;
        }
    }

    public static class Constant
    extends AST {
        private final Object nativeValue;

        public Constant(Token value, Object nativeValue) {
            super(value);
            this.nativeValue = nativeValue;
        }

        public Object toNative() {
            return this.nativeValue;
        }
    }
}

