/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.typeset;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.engine.ConstructionCallback;
import nz.org.riskscape.engine.Identified;
import nz.org.riskscape.engine.IdentifiedCollection;
import nz.org.riskscape.engine.IdentifiedException;
import nz.org.riskscape.engine.ObjectAlreadyExistsException;
import nz.org.riskscape.engine.Reference;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeRegistry;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.types.ancestor.AncestorRule;
import nz.org.riskscape.engine.types.ancestor.AncestorType;
import nz.org.riskscape.engine.types.ancestor.AncestorTypeList;
import nz.org.riskscape.engine.types.eqrule.Coercer;
import nz.org.riskscape.engine.types.eqrule.EquivalenceRule;
import nz.org.riskscape.engine.types.varule.Variance;
import nz.org.riskscape.engine.types.varule.VarianceRule;
import nz.org.riskscape.engine.typeset.CanonicalType;
import nz.org.riskscape.engine.typeset.IdentifiedType;
import nz.org.riskscape.engine.typeset.LinkedType;
import nz.org.riskscape.engine.typeset.MissingTypeException;
import nz.org.riskscape.engine.typeset.TypeRules;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeSet
extends IdentifiedCollection.Base<CanonicalType>
implements TypeRules {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TypeSet.class);
    public static final TypeSet GLOBAL_TYPE_SET = new TypeSet(TypeRegistry.withDefaults());
    private final TypeRegistry typeRegistry;

    public TypeSet() {
        this.typeRegistry = TypeRegistry.withDefaults();
    }

    public void addType(String identifier, Resource resource, ConstructionCallback<Type> builder) {
        super.add(identifier, resource, () -> builder.create().map(t -> this.wrap(identifier, (Type)t)));
    }

    public CanonicalType add(@NonNull String id, @NonNull Type type) throws ObjectAlreadyExistsException {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        CanonicalType ct = this.wrap(id, type);
        this.add(ct);
        return ct;
    }

    private CanonicalType wrap(String id, Type type) {
        return new CanonicalType(id, type){

            @Override
            public TypeSet getTypeSet() {
                return TypeSet.this;
            }
        };
    }

    public LinkedType getLinkedType(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return new LinkedType(this, id);
    }

    @Deprecated
    public CanonicalType getRequired(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.getRequired(id, ProblemSink.DEVNULL);
    }

    public CanonicalType getRequired(@NonNull String id, ProblemSink problemSink) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        try {
            return (CanonicalType)this.get(id, problemSink);
        }
        catch (IdentifiedException e) {
            throw new MissingTypeException(id, e);
        }
    }

    @Override
    public Optional<Coercer> findEquivalenceCoercer(Type sourceType, Type targetType) {
        log.debug("Equivalence search - {} to {}", (Object)sourceType, (Object)targetType);
        return new WrappedTypeRules(0, this, null).findEquivalenceCoercer(sourceType, targetType);
    }

    @Override
    public Variance testVariance(Type sourceType, Type targetType) {
        log.debug("Variance test - {} to {}", (Object)sourceType, (Object)targetType);
        return new WrappedTypeRules(0, this, null).testVariance(sourceType, targetType);
    }

    @Override
    public Optional<AncestorType> computeAncestorType(Type type1, Type type2) {
        return new WrappedTypeRules(0, this, null).computeAncestorType(type1, type2);
    }

    public Type computeAncestorNoConversion(Type type1, Type type2) {
        Type ancestorType = this.computeAncestorType(type1, type2).map(ancestor -> ancestor.isConverting() ? null : ancestor).map(AncestorType::getType).orElse(Types.ANYTHING);
        return Nullable.ifTrue(Nullable.is(type1) || Nullable.is(type2), ancestorType);
    }

    public AncestorTypeList computeAncestors(List<Type> allTypes) {
        AncestorTypeList recursed = this.computeAncestorsRecursive(allTypes);
        if (recursed.getType() == Types.ANYTHING) {
            if (Nullable.any(allTypes.toArray(new Type[0]))) {
                return AncestorTypeList.of(Nullable.ANYTHING);
            }
            return AncestorTypeList.of(Types.ANYTHING);
        }
        return recursed;
    }

    public AncestorTypeList computeAncestorsRecursive(List<Type> allTypes) {
        List distinctTypes = allTypes.stream().distinct().toList();
        if (allTypes.size() == 0) {
            return AncestorTypeList.of(Types.NOTHING);
        }
        if (distinctTypes.size() == 1) {
            return AncestorTypeList.of((Type)distinctTypes.get(0));
        }
        if (distinctTypes.size() == 2) {
            AncestorType ancestorType = this.computeAncestorType((Type)distinctTypes.get(0), (Type)distinctTypes.get(1)).orElse(AncestorType.of(Types.ANYTHING));
            if (ancestorType.isConverting()) {
                return AncestorTypeList.of(ancestorType.getType(), list -> Lists.transform((List)list, element -> ancestorType.getConvert().apply(element)));
            }
            return AncestorTypeList.of(ancestorType.getType());
        }
        List<Type> tail = allTypes.subList(1, allTypes.size());
        AncestorTypeList convertedTail = this.computeAncestors(tail);
        Type head = allTypes.get(0);
        AncestorTypeList convertedHead = this.computeAncestors(Arrays.asList(head, convertedTail.getType()));
        return AncestorTypeList.of(convertedHead.getType(), list -> {
            assert (list.size() == allTypes.size());
            Object headElement = list.get(0);
            List tailElements = (List)convertedTail.getConverter().apply(list.subList(1, list.size()));
            ArrayList combined = new ArrayList(tailElements.size() + 1);
            combined.add(headElement);
            combined.addAll(tailElements);
            return (List)convertedHead.getConverter().apply(combined);
        });
    }

    public void validate(Consumer<Problem> problemConsumer) {
        for (Reference ref : this.getReferences()) {
            if (!ref.getResult().hasProblems()) continue;
            problemConsumer.accept(GeneralProblems.get().failedToValidate(IdentifiedType.class, ref.getId(), ref.getResource()).withSeverity(Problem.max(ref.getResult().getProblems())).withChildren(ref.getResult().getProblems()));
            ref.drainWarnings(p -> {});
        }
    }

    @Override
    public void debug(String msg, Object ... args) {
        log.debug(msg, args);
    }

    @Generated
    public TypeSet(TypeRegistry typeRegistry) {
        this.typeRegistry = typeRegistry;
    }

    @Generated
    public TypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    private class WrappedTypeRules
    implements TypeRules {
        private final int indentLevel;
        private final TypeSet wrapped;
        private final Identified rule;
        private String prefix;

        @Override
        public Variance testVariance(Type sourceType, Type targetType) {
            List<VarianceRule> varianceRules = this.wrapped.getTypeRegistry().getVarianceRules();
            if (this.rule != null) {
                this.debug("Testing variance of {} => {}...", sourceType, targetType);
            }
            for (VarianceRule varianceRule : varianceRules) {
                WrappedTypeRules next;
                Variance variance = varianceRule.test(next = new WrappedTypeRules(this.indentLevel + 1, this.wrapped, varianceRule), sourceType, targetType);
                if (variance == Variance.UNKNOWN) continue;
                this.debug("{} variance returned by rule '{}' for {} to {}", variance.name(), varianceRule.getId(), sourceType, targetType);
                return variance;
            }
            this.debug("No rule matched.", new Object[0]);
            return Variance.UNKNOWN;
        }

        @Override
        public Optional<Coercer> findEquivalenceCoercer(Type sourceType, Type targetType) {
            List<EquivalenceRule> equivalenceRules = this.wrapped.getTypeRegistry().getEquivalenceRules();
            if (this.rule != null) {
                this.debug("Testing equivalence of {} => {}...", sourceType, targetType);
            }
            if (sourceType == targetType) {
                this.debug("Exact same types - returning identity coercer for {}", targetType);
                return Optional.of(Coercer.identity(targetType));
            }
            for (EquivalenceRule equivalenceRule : equivalenceRules) {
                WrappedTypeRules next;
                Optional<Coercer> coercer = equivalenceRule.getCoercer(next = new WrappedTypeRules(this.indentLevel + 1, this.wrapped, equivalenceRule), sourceType, targetType);
                if (!coercer.isPresent()) continue;
                this.debug("Equivalence rule '{}' matched for {} => {}", equivalenceRule.getId(), sourceType, targetType);
                return coercer;
            }
            this.debug("No rule matched", new Object[0]);
            return Optional.empty();
        }

        @Override
        public Optional<AncestorType> computeAncestorType(Type type1, Type type2) {
            List<AncestorRule> ancestorRules = this.wrapped.getTypeRegistry().getAncestorRules();
            if (this.rule != null) {
                this.debug("Testing ancestory of {} => {}...", type1, type2);
            }
            if (type1.equals(type2)) {
                this.debug("Same types - returning identity", new Object[0]);
                return Optional.of(AncestorType.of(type1));
            }
            for (AncestorRule ancestorRule : ancestorRules) {
                WrappedTypeRules next;
                Optional<AncestorType> ancestor = ancestorRule.computeAncestor(next = new WrappedTypeRules(this.indentLevel + 1, this.wrapped, ancestorRule), type1, type2);
                if (!ancestor.isPresent()) continue;
                this.debug("Ancestor rule '{}' matched for {} => {}", ancestorRule.getId(), type1, type2);
                return ancestor;
            }
            this.debug("No rule matched", new Object[0]);
            return Optional.empty();
        }

        @Override
        public void debug(String msg, Object ... args) {
            if (log.isDebugEnabled()) {
                if (this.prefix == null) {
                    String indent = Strings.repeat((String)"  ", (int)this.indentLevel);
                    this.prefix = this.rule == null ? "" : indent + " [in " + this.rule.getId() + "] ";
                }
                log.debug(this.prefix + msg, args);
            }
        }

        @Generated
        public WrappedTypeRules(int indentLevel, TypeSet wrapped, Identified rule) {
            this.indentLevel = indentLevel;
            this.wrapped = wrapped;
            this.rule = rule;
        }
    }
}

