/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types.varule;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.Objects;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.varule.Variance;
import nz.org.riskscape.engine.types.varule.VarianceRule;
import nz.org.riskscape.engine.typeset.TypeRules;

public class WrappingTypesRule
implements VarianceRule {
    @Override
    public Variance test(TypeRules typeRules, Type source, Type target) {
        if (!source.isWrapped() && !target.isWrapped()) {
            return Variance.UNKNOWN;
        }
        Iterator sourceTypes = Lists.reverse(source.unwrap()).iterator();
        for (Type targetPart : Lists.reverse(target.unwrap())) {
            Type sourcePart;
            if (Objects.equals(targetPart, sourcePart = sourceTypes.hasNext() ? (Type)sourceTypes.next() : null)) continue;
            if (targetPart == null) {
                return Variance.COVARIANT;
            }
            if (sourcePart == null) {
                return Variance.INVARIANT;
            }
            if (sourcePart.equals(source) && targetPart.equals(target)) {
                return Variance.UNKNOWN;
            }
            return typeRules.testVariance(sourcePart, targetPart);
        }
        return Variance.COVARIANT;
    }
}

