/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types.eqrule;

import java.util.Optional;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.types.eqrule.Coercer;
import nz.org.riskscape.engine.types.eqrule.EquivalenceRule;
import nz.org.riskscape.engine.typeset.TypeRules;

public class StructGeometryRule
implements EquivalenceRule {
    @Override
    public Optional<Coercer> getCoercer(TypeRules typeRules, Type sourceType, Type targetType) {
        if (!typeRules.isAssignable(targetType, Types.GEOMETRY)) {
            return Optional.empty();
        }
        Struct sourceStruct = sourceType.find(Struct.class).orElse(null);
        if (sourceStruct == null) {
            return Optional.empty();
        }
        Struct.StructMember geomMember = null;
        Optional<Object> geomCoercer = Optional.empty();
        for (Struct.StructMember member : sourceStruct.getMembers()) {
            Optional<Object> coercer = typeRules.isAssignable(member.getType(), Types.GEOMETRY) ? Optional.of(Coercer.identity(member.getType())) : (member.getType().find(Struct.class).isPresent() ? Optional.empty() : typeRules.findEquivalenceCoercer(member.getType(), Types.GEOMETRY));
            if (!coercer.isPresent()) continue;
            if (geomMember == null) {
                geomMember = member;
                geomCoercer = coercer;
                continue;
            }
            return Optional.empty();
        }
        if (geomMember == null) {
            return Optional.empty();
        }
        Struct.StructMember foundMember = geomMember;
        Coercer foundCoercer = (Coercer)geomCoercer.get();
        return Optional.of(Coercer.build(sourceType, foundCoercer.getTargetType(), sourceValue -> {
            Tuple tuple = (Tuple)sourceValue;
            return foundCoercer.apply(tuple.fetch(foundMember));
        }));
    }
}

