/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types.eqrule;

import java.util.Optional;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.eqrule.Coercer;
import nz.org.riskscape.engine.types.eqrule.EquivalenceRule;
import nz.org.riskscape.engine.typeset.TypeRules;

public class SingleValueStructRule
implements EquivalenceRule {
    @Override
    public Optional<Coercer> getCoercer(TypeRules typeRules, Type sourceType, Type targetType) {
        if (this.singleMemberStruct(sourceType)) {
            Struct targetStruct;
            Struct sourceStruct = sourceType.find(Struct.class).get();
            if (sourceStruct == (targetStruct = (Struct)targetType.find(Struct.class).orElse(null))) {
                return Optional.empty();
            }
            Type memberType = sourceStruct.getMembers().get(0).getType();
            if (typeRules.isAssignable(memberType, targetType)) {
                return this.structToValue(sourceType, memberType, null);
            }
            return typeRules.findEquivalenceCoercer(memberType, targetType).map(subCoercer -> this.structToValue(sourceType, subCoercer.getTargetType(), (Coercer)subCoercer).get());
        }
        if (this.singleMemberStruct(targetType)) {
            Struct targetStruct = targetType.find(Struct.class).get();
            Struct sourceStruct = sourceType.find(Struct.class).orElse(null);
            if (sourceStruct == targetStruct) {
                return Optional.empty();
            }
            Type memberType = targetStruct.getMembers().get(0).getType();
            if (typeRules.isAssignable(sourceType, memberType)) {
                return this.valueToStruct(sourceType, targetType, targetStruct, null);
            }
            return typeRules.findEquivalenceCoercer(sourceType, memberType).map(subCoercer -> this.valueToStruct(sourceType, targetType, targetStruct, (Coercer)subCoercer).get());
        }
        return Optional.empty();
    }

    private Optional<Coercer> valueToStruct(Type source, Type target, Struct targetStruct, Coercer subCoercer) {
        return Optional.of(Coercer.build(source, target, value -> Tuple.ofValues(targetStruct, subCoercer == null ? value : subCoercer.apply(value))));
    }

    private Optional<Coercer> structToValue(Type source, Type target, Coercer subCoercer) {
        return Optional.of(Coercer.build(source, target, tuple -> {
            Object rawValue = ((Tuple)tuple).fetch(0);
            if (subCoercer == null) {
                return rawValue;
            }
            return subCoercer.apply(rawValue);
        }));
    }

    private boolean singleMemberStruct(Type type) {
        return type.find(Struct.class).map(Struct::size).orElse(0) == 1;
    }
}

